--===============================================================================================
-- DBMS name:      ORACLE Version 12cR2                         
-- Created on:     24/01/2011 11:26:48                          
--===============================================================================================
CONNECT / AS SYSDBA
COLUMN REP_FICHIERS NEW_VAL REP_FICHIERS

SELECT SUBSTR(NAME,1,INSTR(NAME,'\',-1)-1) REP_FICHIERS
FROM V$DATAFILE WHERE ROWNUM < 2;

ALTER SYSTEM SET db_create_file_dest='&REP_FICHIERS';
ALTER SYSTEM SET SEC_CASE_SENSITIVE_LOGON=FALSE;
ALTER SYSTEM SET DEFERRED_SEGMENT_CREATION=FALSE;

--===============================================================================================
--Tablespaces 
--===============================================================================================
CREATE TABLESPACE DTB_STAR DATAFILE SIZE 10M AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED;
CREATE TABLESPACE DTB_TRAN DATAFILE SIZE 10M AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED;
CREATE TABLESPACE ITB_STAR DATAFILE SIZE 10M AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED;
CREATE TABLESPACE ITB_TRAN DATAFILE SIZE 10M AUTOEXTEND ON NEXT 10M MAXSIZE UNLIMITED;
CREATE TABLESPACE GEST_DATA DATAFILE SIZE 50M AUTOEXTEND ON NEXT 100M MAXSIZE UNLIMITED;
CREATE TABLESPACE GEST_INDX DATAFILE SIZE 50M AUTOEXTEND ON NEXT 100M MAXSIZE UNLIMITED;
CREATE TABLESPACE GEST_ETOILE_DATA DATAFILE SIZE 50M AUTOEXTEND ON NEXT 100M MAXSIZE UNLIMITED;
CREATE TABLESPACE GEST_ETOILE_INDX DATAFILE SIZE 50M AUTOEXTEND ON NEXT 100M MAXSIZE UNLIMITED;
CREATE TABLESPACE GEST_DATA_CLOB DATAFILE SIZE 50M AUTOEXTEND ON NEXT 100M MAXSIZE UNLIMITED;
CREATE TABLESPACE GEST_DATA_BLOB DATAFILE SIZE 50M AUTOEXTEND ON NEXT 100M MAXSIZE UNLIMITED;
SPOOL schema_exemple_12c_new.TXT
	
--===============================================================================================
--Utilisateur 
--===============================================================================================
GRANT DBA TO STAGIAIRE IDENTIFIED BY PWD; 
ALTER USER STAGIAIRE DEFAULT TABLESPACE DTB_TRAN;
GRANT ADVISOR, ADMINISTER SQL TUNING SET TO STAGIAIRE;
--===============================================================================================
--Schema 
--===============================================================================================
CONNECT STAGIAIRE/PWD
SET AUTOCOMMIT ON
--===============================================================================================
--                  Table: CATEGORIES                                            
--===============================================================================================
CREATE TABLE CATEGORIES  (
   CODE_CATEGORIE       NUMBER(6)                       NOT NULL,
   NOM_CATEGORIE        VARCHAR2(25)                    NOT NULL,
   DESCRIPTION          VARCHAR2(100)                   NOT NULL,
   CONSTRAINT CATEGORIES_PK PRIMARY KEY (CODE_CATEGORIE)
         USING INDEX TABLESPACE ITB_TRAN
)TABLESPACE DTB_TRAN ;
--===============================================================================================
--                  Table: CLIENTS                                               
--===============================================================================================
CREATE TABLE CLIENTS  (
   CODE_CLIENT          CHAR(5)                         NOT NULL,
   SOCIETE              NVARCHAR2(40)                   NOT NULL,
   ADRESSE              NVARCHAR2(60)                   NOT NULL,
   VILLE                VARCHAR2(30)                    NOT NULL,
   CODE_POSTAL          VARCHAR2(10)                    NOT NULL,
   PAYS                 VARCHAR2(15)                    NOT NULL,
   TELEPHONE            VARCHAR2(24)                    NOT NULL,
   FAX                  VARCHAR2(24),
   CONSTRAINT CLIENTS_PK PRIMARY KEY (CODE_CLIENT)
         USING INDEX TABLESPACE ITB_TRAN
)TABLESPACE DTB_TRAN ;

--===============================================================================================
--                  Table: COMMANDES                                             
--===============================================================================================
CREATE TABLE COMMANDES  (
   NO_COMMANDE          NUMBER(6)                       NOT NULL,
   CODE_CLIENT          CHAR(5)                         NOT NULL,
   NO_EMPLOYE           NUMBER(6)                       NOT NULL,
   DATE_COMMANDE        DATE                            NOT NULL,
   DATE_ENVOI           DATE,
   PORT                 NUMBER(8,2),
   LIVREE               NUMBER(1)             DEFAULT 0 NOT NULL,
   ACQUITEE             NUMBER(1)             DEFAULT 0 NOT NULL,
   ANNULEE              NUMBER(1)             DEFAULT 0 NOT NULL,
   ANNEE                NUMBER(4) AS (EXTRACT(YEAR FROM DATE_COMMANDE)),
   TRIMESTRE            NUMBER(1) AS (TO_NUMBER(TO_CHAR(DATE_COMMANDE,'Q'))),
   MOIS                 NUMBER(2) AS (EXTRACT(MONTH FROM DATE_COMMANDE)),
   CONSTRAINT COMMANDES_PK PRIMARY KEY (NO_COMMANDE)
   USING INDEX STORAGE ( INITIAL 1M ) TABLESPACE ITB_TRAN
)TABLESPACE DTB_TRAN ;

--===============================================================================================
--                  Index: COMM_CLIE_FK                                          
--===============================================================================================
CREATE INDEX COMM_CLIE_FK ON COMMANDES (
   CODE_CLIENT ASC
)TABLESPACE ITB_TRAN;

--===============================================================================================
--                  Index: COMM_EMPL_FK                                          
--===============================================================================================
CREATE INDEX COMM_EMPL_FK ON COMMANDES (
   NO_EMPLOYE ASC
)TABLESPACE ITB_TRAN;

--===============================================================================================
--                  Table: DETAILS_COMMANDES                                     
--===============================================================================================
CREATE TABLE DETAILS_COMMANDES  (
   NO_COMMANDE          NUMBER(6)                       NOT NULL,
   REF_PRODUIT          NUMBER(6)                       NOT NULL,
   PRIX_UNITAIRE        NUMBER(8,2)                     NOT NULL,
   QUANTITE             NUMBER(5)                       NOT NULL,
   REMISE               NUMBER(8,2)                     NOT NULL,
   RETOURNE             NUMBER(1)             DEFAULT 0 NOT NULL,
   ECHANGE              NUMBER(1)             DEFAULT 0 NOT NULL,
   CONSTRAINT DETAILS_COMMANDES_PK 
       PRIMARY KEY (NO_COMMANDE, REF_PRODUIT) USING INDEX
)TABLESPACE DTB_TRAN ;

--===============================================================================================
--                  Index: DET_COMM_COMM_FK                                      
--===============================================================================================
CREATE INDEX DET_COMM_COMM_FK ON DETAILS_COMMANDES (
   NO_COMMANDE ASC
)TABLESPACE ITB_TRAN;

--===============================================================================================
--                  Index: DET_COMM_PROD_FK                                      
--===============================================================================================
CREATE INDEX DET_COMM_PROD_FK ON DETAILS_COMMANDES (
   REF_PRODUIT ASC
)TABLESPACE ITB_TRAN;

--===============================================================================================
--                  Table: EMPLOYES                                              
--===============================================================================================
CREATE TABLE EMPLOYES  (
   NO_EMPLOYE           NUMBER(6)                       NOT NULL,
   REND_COMPTE          NUMBER(6),
   NOM                  NVARCHAR2(40)                   NOT NULL,
   PRENOM               NVARCHAR2(30)                   NOT NULL,
   FONCTION             VARCHAR2(30)                    NOT NULL,
   TITRE                VARCHAR2(5)                     NOT NULL,
   DATE_NAISSANCE       DATE                            NOT NULL,
   DATE_EMBAUCHE        DATE                           DEFAULT SYSDATE NOT NULL,
   SALAIRE              NUMBER(8,2)                     NOT NULL,
   COMMISSION           NUMBER(8,2),
   PAYS                 VARCHAR(20),
   REGION               VARCHAR(50),
   CONSTRAINT EMPLOYES_PK PRIMARY KEY (NO_EMPLOYE)
         USING INDEX TABLESPACE ITB_TRAN
)
TABLESPACE DTB_TRAN ;

--===============================================================================================
--                  Index: EMPL_EMPL_FK                                          
--===============================================================================================
CREATE INDEX EMPL_EMPL_FK ON EMPLOYES (
   REND_COMPTE ASC
)
TABLESPACE ITB_TRAN;

--===============================================================================================
--                  Table: FOURNISSEURS                                          
--===============================================================================================
CREATE TABLE FOURNISSEURS  (
   NO_FOURNISSEUR       NUMBER(6)                       NOT NULL,
   SOCIETE              NVARCHAR2(40)                   NOT NULL,
   ADRESSE              NVARCHAR2(60)                   NOT NULL,
   VILLE                VARCHAR2(30)                    NOT NULL,
   CODE_POSTAL          VARCHAR2(10)                    NOT NULL,
   PAYS                 VARCHAR2(15)                    NOT NULL,
   TELEPHONE            VARCHAR2(24)                    NOT NULL,
   FAX                  VARCHAR2(24),
   CONSTRAINT FOURNISSEURS_PK PRIMARY KEY (NO_FOURNISSEUR)
         USING INDEX TABLESPACE ITB_TRAN
)
TABLESPACE DTB_TRAN ;

--===============================================================================================
--                  Table: PRODUITS                                              
--===============================================================================================
CREATE TABLE PRODUITS  (
   REF_PRODUIT          NUMBER(6)                       NOT NULL,
   NOM_PRODUIT          NVARCHAR2(50)                   NOT NULL,
   NO_FOURNISSEUR       NUMBER(6)                       NOT NULL,
   CODE_CATEGORIE       NUMBER(6)                       NOT NULL,
   QUANTITE             VARCHAR2(30),
   PRIX_UNITAIRE        NUMBER(8,2)                     NOT NULL,
   UNITES_STOCK         NUMBER(5),
   UNITES_COMMANDEES    NUMBER(5),
   INDISPONIBLE         NUMBER(1)                       NOT NULL,
   CONSTRAINT PRODUITS_PK PRIMARY KEY (REF_PRODUIT)
         USING INDEX TABLESPACE ITB_TRAN
)
TABLESPACE DTB_TRAN ;

--===============================================================================================
--                  Index: PROD_CATE_FK                                          
--===============================================================================================
CREATE INDEX PROD_CATE_FK ON PRODUITS (
   CODE_CATEGORIE ASC
)TABLESPACE ITB_TRAN;

--===============================================================================================
--                  Index: PROD_FOUR_FK                                          
--===============================================================================================
CREATE INDEX PROD_FOUR_FK ON PRODUITS (
   NO_FOURNISSEUR ASC
)TABLESPACE ITB_TRAN;

ALTER TABLE COMMANDES
	ADD CONSTRAINT COMMANDES_UK UNIQUE ( CODE_CLIENT, DATE_COMMANDE)
	  USING INDEX TABLESPACE ITB_TRAN;

ALTER TABLE COMMANDES
   ADD CONSTRAINT COMM_CLIE_FK FOREIGN KEY (CODE_CLIENT)
      REFERENCES CLIENTS (CODE_CLIENT)
      NOT DEFERRABLE;

ALTER TABLE COMMANDES
   ADD CONSTRAINT COMM_EMPL_FK FOREIGN KEY (NO_EMPLOYE)
      REFERENCES EMPLOYES (NO_EMPLOYE)
      NOT DEFERRABLE;

ALTER TABLE DETAILS_COMMANDES
   ADD CONSTRAINT DET_COMM_COMM_FK FOREIGN KEY (NO_COMMANDE)
      REFERENCES COMMANDES (NO_COMMANDE)
      NOT DEFERRABLE;

ALTER TABLE DETAILS_COMMANDES
   ADD CONSTRAINT DET_COMM_PROD_FK FOREIGN KEY (REF_PRODUIT)
      REFERENCES PRODUITS (REF_PRODUIT)
      NOT DEFERRABLE;

ALTER TABLE EMPLOYES
   ADD CONSTRAINT EMPL_EMPL_FK FOREIGN KEY (REND_COMPTE)
      REFERENCES EMPLOYES (NO_EMPLOYE)
      NOT DEFERRABLE;

ALTER TABLE PRODUITS
   ADD CONSTRAINT PROD_CATE_FK FOREIGN KEY (CODE_CATEGORIE)
      REFERENCES CATEGORIES (CODE_CATEGORIE)
      NOT DEFERRABLE;

ALTER TABLE PRODUITS
   ADD CONSTRAINT PROD_FOUR_FK FOREIGN KEY (NO_FOURNISSEUR)
      REFERENCES FOURNISSEURS (NO_FOURNISSEUR)
      NOT DEFERRABLE;
	  

/*=========================================================*/
/* Table: DIM_CLIENTS                                      */
/*=========================================================*/
CREATE TABLE DIM_CLIENTS  (
   CODE_CLIENT          CHAR(5)                    NOT NULL,
   CLIENT               NVARCHAR2(40)              NOT NULL,
   VILLE                VARCHAR2(30)               NOT NULL,
   PAYS                 VARCHAR2(15)               NOT NULL,
   CONSTRAINT PK_DIM_CLIENTS PRIMARY KEY (CODE_CLIENT)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: DIM_EMPLOYES                                     */
/*=========================================================*/
CREATE TABLE DIM_EMPLOYES  (
   NO_EMPLOYE           NUMBER(6)                  NOT NULL,
   EMPLOYE              NVARCHAR2(70)              NOT NULL,
   FONCTION             VARCHAR2(30)               NOT NULL,
   CONSTRAINT PK_DIM_EMPLOYES PRIMARY KEY (NO_EMPLOYE)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: DIM_PRODUITS                                     */
/*=========================================================*/
CREATE TABLE DIM_PRODUITS  (
   REF_PRODUIT          NUMBER(6)                  NOT NULL,
   NOM_PRODUIT          NVARCHAR2(50)              NOT NULL,
   NOM_CATEGORIE        VARCHAR2(25)               NOT NULL,
   CONSTRAINT PK_DIM_PRODUITS PRIMARY KEY (REF_PRODUIT)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: DIM_TEMPS                                        */
/*=========================================================*/
CREATE TABLE DIM_TEMPS  (
   JOUR                 DATE                       NOT NULL,
   SEMAINE              NUMBER(2)                  NOT NULL,
   MOIS                 VARCHAR2(18)               NOT NULL,
   MOIS_N               NUMBER(2)                  NOT NULL,
   TRIMESTRE            NUMBER(1)                  NOT NULL,
   ANNEE                NUMBER(4)                  NOT NULL,
   CONSTRAINT PK_DIM_TEMPS PRIMARY KEY (JOUR)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: INDICATEURS                                      */
/*=========================================================*/
CREATE TABLE INDICATEURS  (
   JOUR                 DATE                       NOT NULL,
   REF_PRODUIT          NUMBER(6)                  NOT NULL,
   CODE_CLIENT          CHAR(5)                    NOT NULL,
   NO_EMPLOYE           NUMBER(6)                  NOT NULL,
   NO_COMMANDE          NUMBER(6)                  NOT NULL,
   PORT                 NUMBER(12,2),
   QUANTITE             NUMBER(5),
   PRIX_UNITAIRE        NUMBER(12,2),
   CONSTRAINT PK_IND PRIMARY KEY 
   (JOUR, REF_PRODUIT, CODE_CLIENT, NO_EMPLOYE, NO_COMMANDE)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Index: FK_IND_REF_DIM_TEMP                              */
/*=========================================================*/
CREATE INDEX FK_IND_REF_DIM_TEMP ON 
 INDICATEURS ( JOUR ASC) TABLESPACE GEST_ETOILE_INDX;
/*=========================================================*/
/* Index: FK_IND_REF_DIM_PROD                              */
/*=========================================================*/
CREATE INDEX FK_IND_REF_DIM_PROD ON 
INDICATEURS ( REF_PRODUIT ASC )TABLESPACE GEST_ETOILE_INDX;
/*=========================================================*/
/* Index: FK_IND_REF_DIM_CLIE                              */
/*=========================================================*/
CREATE INDEX FK_IND_REF_DIM_CLIE ON 
INDICATEURS ( CODE_CLIENT ASC )TABLESPACE GEST_ETOILE_INDX;
/*=========================================================*/
/* Index: FK_IND_REF_DIM_EMPL                              */
/*=========================================================*/
CREATE INDEX FK_IND_REF_DIM_EMPL ON 
INDICATEURS ( NO_EMPLOYE ASC)TABLESPACE GEST_ETOILE_INDX;
/*=========================================================*/
/* Table: QUANTITES_CLIENTS                                */
/*=========================================================*/
CREATE TABLE QUANTITES_CLIENTS  (
   ANNEE                NUMBER(4),
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   QUANTITE             NUMBER(5),
   PORT                 NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_ANNEES                                    */
/*=========================================================*/
CREATE TABLE VENTES_ANNEES  (
   ANNEE                NUMBER(4),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_CLIENTS                                   */
/*=========================================================*/
CREATE TABLE VENTES_CLIENTS  (
   ANNEE                NUMBER(4),
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_CLIENTS_2009                              */
/*=========================================================*/
CREATE TABLE VENTES_CLIENTS_2009  (
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_CLIENTS_2010                              */
/*=========================================================*/
CREATE TABLE VENTES_CLIENTS_2010  (
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_CLIENTS_2011                              */
/*=========================================================*/
CREATE TABLE VENTES_CLIENTS_2011  (
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_MOIS                                      */
/*=========================================================*/
CREATE TABLE VENTES_MOIS  (
   ANNEE                NUMBER(4),
   MOIS                 NUMBER(2),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;

ALTER TABLE INDICATEURS
   ADD CONSTRAINT FK_IND_REF_DIM_CLIE FOREIGN KEY (CODE_CLIENT)
      REFERENCES DIM_CLIENTS (CODE_CLIENT)
      NOT DEFERRABLE;

ALTER TABLE INDICATEURS
   ADD CONSTRAINT FK_IND_REF_DIM_EMPL FOREIGN KEY (NO_EMPLOYE)
      REFERENCES DIM_EMPLOYES (NO_EMPLOYE)
      NOT DEFERRABLE;

ALTER TABLE INDICATEURS
   ADD CONSTRAINT FK_IND_REF_DIM_PROD FOREIGN KEY (REF_PRODUIT)
      REFERENCES DIM_PRODUITS (REF_PRODUIT)
      NOT DEFERRABLE;

ALTER TABLE INDICATEURS
   ADD CONSTRAINT FK_IND_REF_DIM_TEMP FOREIGN KEY (JOUR)
      REFERENCES DIM_TEMPS (JOUR)
      NOT DEFERRABLE;

CREATE OR REPLACE DIRECTORY SCHEMA_EXEMPLE AS 'C:\Oracle12cSQL_PLSQL\stagiaire';
--===============================================================================================
--                  Table: CATEGORIES                                            
--===============================================================================================
CREATE TABLE IMP_CATEGORIES  (
   CODE_CATEGORIE       NUMBER(6)     ,
   NOM_CATEGORIE        VARCHAR2(25)  ,
   DESCRIPTION          VARCHAR2(100) )
ORGANIZATION EXTERNAL 
	( TYPE ORACLE_DATAPUMP DEFAULT 
	DIRECTORY SCHEMA_EXEMPLE LOCATION ( 'CATEGORIES.DAT'));
--===============================================================================================
--                  Table: CLIENTS                                               
--===============================================================================================
CREATE TABLE IMP_CLIENTS  (
   CODE_CLIENT          CHAR(5)       ,
   SOCIETE              NVARCHAR2(40) ,
   ADRESSE              NVARCHAR2(60) ,
   VILLE                VARCHAR2(30)  ,
   CODE_POSTAL          VARCHAR2(10)  ,
   PAYS                 VARCHAR2(15)  ,
   TELEPHONE            VARCHAR2(24)  ,
   FAX                  VARCHAR2(24))
ORGANIZATION EXTERNAL 
	( TYPE ORACLE_DATAPUMP DEFAULT 
	DIRECTORY SCHEMA_EXEMPLE LOCATION ( 'CLIENTS.DAT'));
--===============================================================================================
--                  Table: COMMANDES                                             
--===============================================================================================
CREATE TABLE IMP_COMMANDES  (
   NO_COMMANDE          NUMBER(6)     ,
   CODE_CLIENT          CHAR(5)       ,
   NO_EMPLOYE           NUMBER(6)     ,
   DATE_COMMANDE        DATE          ,
   DATE_ENVOI           DATE          ,
   PORT                 NUMBER(8,2)   ,
   LIVREE               NUMBER(1)     ,
   ACQUITEE             NUMBER(1)     ,
   ANNULEE              NUMBER(1)     ,
   ANNEE                NUMBER(4)     ,
   TRIMESTRE            NUMBER(1)     ,
   MOIS                 NUMBER(2))
ORGANIZATION EXTERNAL 
	( TYPE ORACLE_DATAPUMP DEFAULT 
	DIRECTORY SCHEMA_EXEMPLE LOCATION ( 'COMMANDES.DAT'));
--===============================================================================================
--                  Table: DETAILS_COMMANDES                                     
--===============================================================================================
CREATE TABLE IMP_DETAILS_COMMANDES  (
   NO_COMMANDE          NUMBER(6)     ,
   REF_PRODUIT          NUMBER(6)     ,
   PRIX_UNITAIRE        NUMBER(8,2)   ,
   QUANTITE             NUMBER(5)     ,
   REMISE               NUMBER(8,2)   ,
   RETOURNE             NUMBER(1)     ,
   ECHANGE              NUMBER(1)     )
ORGANIZATION EXTERNAL 
	( TYPE ORACLE_DATAPUMP DEFAULT 
	DIRECTORY SCHEMA_EXEMPLE LOCATION ( 'DETAILS_COMMANDES.DAT'));
--===============================================================================================
--                  Table: EMPLOYES                                              
--===============================================================================================
CREATE TABLE IMP_EMPLOYES  (
   NO_EMPLOYE           NUMBER(6)     ,
   REND_COMPTE          NUMBER(6)     ,
   NOM                  NVARCHAR2(40) ,
   PRENOM               NVARCHAR2(30) ,
   FONCTION             VARCHAR2(30)  ,
   TITRE                VARCHAR2(5)   ,
   DATE_NAISSANCE       DATE          ,
   DATE_EMBAUCHE        DATE          ,
   SALAIRE              NUMBER(8,2)   ,
   COMMISSION           NUMBER(8,2)   ,
   PAYS                 VARCHAR(20)   ,
   REGION               VARCHAR(50))
ORGANIZATION EXTERNAL 
	( TYPE ORACLE_DATAPUMP DEFAULT 
	DIRECTORY SCHEMA_EXEMPLE LOCATION ( 'EMPLOYES.DAT'));
--===============================================================================================
--                  Table: FOURNISSEURS                                          
--===============================================================================================
CREATE TABLE IMP_FOURNISSEURS  (
   NO_FOURNISSEUR       NUMBER(6)     ,
   SOCIETE              NVARCHAR2(40) ,
   ADRESSE              NVARCHAR2(60) ,
   VILLE                VARCHAR2(30)  ,
   CODE_POSTAL          VARCHAR2(10)  ,
   PAYS                 VARCHAR2(15)  ,
   TELEPHONE            VARCHAR2(24)  ,
   FAX                  VARCHAR2(24))
ORGANIZATION EXTERNAL 
	( TYPE ORACLE_DATAPUMP DEFAULT 
	DIRECTORY SCHEMA_EXEMPLE LOCATION ( 'FOURNISSEURS.DAT'));
--===============================================================================================
--                  Table: PRODUITS                                              
--===============================================================================================
CREATE TABLE IMP_PRODUITS  (
   REF_PRODUIT          NUMBER(6)     ,
   NOM_PRODUIT          NVARCHAR2(50) ,
   NO_FOURNISSEUR       NUMBER(6)     ,
   CODE_CATEGORIE       NUMBER(6)     ,
   QUANTITE             VARCHAR2(30)  ,
   PRIX_UNITAIRE        NUMBER(8,2)   ,
   UNITES_STOCK         NUMBER(5)     ,
   UNITES_COMMANDEES    NUMBER(5)     ,
   INDISPONIBLE         NUMBER(1)     )
ORGANIZATION EXTERNAL 
	( TYPE ORACLE_DATAPUMP DEFAULT 
	DIRECTORY SCHEMA_EXEMPLE LOCATION ( 'PRODUITS.DAT'));
	  
--===============================================================================================
--                  Table: DIM_TEMPS                                             
--===============================================================================================
CREATE TABLE IMP_DIM_TEMPS  (
   JOUR                 DATE          ,
   SEMAINE              NUMBER(2)     ,
   MOIS                 VARCHAR2(18)  ,
   MOIS_N               NUMBER(2)     ,
   TRIMESTRE            NUMBER(1)     ,
   ANNEE                NUMBER(4)     )
ORGANIZATION EXTERNAL 
	( TYPE ORACLE_DATAPUMP DEFAULT 
	DIRECTORY SCHEMA_EXEMPLE LOCATION ( 'DIM_TEMPS.DAT'));


INSERT INTO CATEGORIES (CODE_CATEGORIE,NOM_CATEGORIE,DESCRIPTION) 
SELECT CODE_CATEGORIE,NOM_CATEGORIE,DESCRIPTION 
FROM IMP_CATEGORIES;

INSERT INTO CLIENTS (CODE_CLIENT,SOCIETE,ADRESSE,VILLE,CODE_POSTAL,PAYS,TELEPHONE,FAX) 
SELECT CODE_CLIENT,SOCIETE,ADRESSE,VILLE,CODE_POSTAL,PAYS,TELEPHONE,FAX 
FROM IMP_CLIENTS;

INSERT INTO EMPLOYES (NO_EMPLOYE,REND_COMPTE,NOM,PRENOM,FONCTION,TITRE,DATE_NAISSANCE,
                      DATE_EMBAUCHE,SALAIRE,COMMISSION,PAYS,REGION)
SELECT NO_EMPLOYE,REND_COMPTE,NOM,PRENOM,FONCTION,TITRE,DATE_NAISSANCE,
                      DATE_EMBAUCHE,SALAIRE,COMMISSION,PAYS,REGION 
FROM IMP_EMPLOYES;

INSERT INTO FOURNISSEURS (NO_FOURNISSEUR,SOCIETE,ADRESSE,VILLE,CODE_POSTAL,PAYS,TELEPHONE,FAX)
SELECT NO_FOURNISSEUR,SOCIETE,ADRESSE,VILLE,CODE_POSTAL,PAYS,TELEPHONE,FAX 
FROM IMP_FOURNISSEURS;

INSERT INTO PRODUITS (REF_PRODUIT,NOM_PRODUIT,NO_FOURNISSEUR,CODE_CATEGORIE,QUANTITE,
                      PRIX_UNITAIRE,UNITES_STOCK,UNITES_COMMANDEES,INDISPONIBLE)
SELECT REF_PRODUIT,NOM_PRODUIT,NO_FOURNISSEUR,CODE_CATEGORIE,QUANTITE,
                      PRIX_UNITAIRE,UNITES_STOCK,UNITES_COMMANDEES,INDISPONIBLE
FROM IMP_PRODUITS;

INSERT INTO COMMANDES (NO_COMMANDE,CODE_CLIENT,NO_EMPLOYE,DATE_COMMANDE,
                       DATE_ENVOI,PORT,LIVREE,ACQUITEE,ANNULEE)
SELECT NO_COMMANDE,CODE_CLIENT,NO_EMPLOYE,DATE_COMMANDE,
                       DATE_ENVOI,PORT,LIVREE,ACQUITEE,ANNULEE 
FROM IMP_COMMANDES;

INSERT INTO DETAILS_COMMANDES (NO_COMMANDE,REF_PRODUIT,PRIX_UNITAIRE,QUANTITE,REMISE,RETOURNE,ECHANGE)
SELECT NO_COMMANDE,REF_PRODUIT,PRIX_UNITAIRE,QUANTITE,REMISE,RETOURNE,ECHANGE 
FROM IMP_DETAILS_COMMANDES;

INSERT INTO DIM_TEMPS (JOUR,SEMAINE,MOIS,MOIS_N,TRIMESTRE,ANNEE) 
SELECT JOUR,SEMAINE,MOIS,MOIS_N,TRIMESTRE,ANNEE FROM IMP_DIM_TEMPS;

SET AUTOCOMMIT OFF
DROP TABLE IMP_COMMANDES ;
DROP TABLE IMP_DETAILS_COMMANDES ;
DROP TABLE IMP_PRODUITS ;
DROP TABLE IMP_FOURNISSEURS ;
DROP TABLE IMP_EMPLOYES ;
DROP TABLE IMP_CLIENTS ;
DROP TABLE IMP_CATEGORIES ;
DROP TABLE IMP_DIM_TEMPS ;

BEGIN
  DBMS_STATS.GATHER_SCHEMA_STATS(
		OWNNAME          => USER ,
		CASCADE          => TRUE,
		ESTIMATE_PERCENT => NULL,
		DEGREE           => NULL,
		NO_INVALIDATE    => FALSE,
		GRANULARITY      => 'ALL',
		METHOD_OPT       => 'FOR ALL COLUMNS SIZE 254',
		OPTIONS          => 'GATHER');
  DBMS_STATS.CREATE_STAT_TABLE   ( USER, STATTAB => 'STATISTIQUES');
  DBMS_STATS.EXPORT_SCHEMA_STATS ( USER, STATTAB => 'STATISTIQUES');
END;
/
	
SPOOL OFF
EXIT;