// JavaScript Document
window.onload=testerNavigateur;
//-----------------------------
function testerNavigateur() {   
	objetXHR = creationXHR();
	if(objetXHR==null) {
		document.getElementById("button").disabled= true;
		var erreurNavigateur="Erreur Navigateur : Création d'objet XHR impossible";
		remplacerContenu("info", erreurNavigateur);
	    document.getElementById("info").style.visibility="visible";
	}
	document.getElementById("button").onclick=jouer;
	document.getElementById("nom").onchange=function() {recupPrenoms(this.value);}
	document.getElementById("prenom").onchange=demandeGains;
}
//##############################MOTEUR AJAX 1############################################
function jouer() {   
	 /*-----------------------------Config et envoi de la requete ASYNCHRONE : */
	 objetXHR = creationXHR();//création d'un objet XHR multi-navigateurs
	 var temps = new Date().getTime();//création d'une variable temps pour l'anti-cache
	 //construction de la chaine des parametres
	 var parametres = "nom="+ codeContenu("nom") +
	 				  "&prenom="+ codeContenu("prenom") +
	                  "&anticache="+temps ;
	 //Config. objet XHR
     objetXHR.open("get","gainAleatoire.php?"+parametres, true); 
	 objetXHR.onreadystatechange = actualiserPage;//désignation de la fonction de rappel
	 //gestion du bouton et du chargeur
	 document.getElementById("button").disabled= true;
	 document.getElementById("charge").style.visibility="visible";
     objetXHR.send(null);//envoi de la requete
	 /*---------------------------------------- */
  }
  function actualiserPage() {
	if (objetXHR.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR.status == 200) {
	   demandeGains();
       var nouveauResultat = objetXHR.responseText.split(":");//recup du résulat > tableau 
	   //actualisation du résultat
	   remplacerContenu("resultat", decodeURI(nouveauResultat[1]));
	   //actualisation du nom
	   remplacerContenu("gagnant", decodeURI(nouveauResultat[0]));
	   //affiche la zone info
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   document.getElementById("charge").style.visibility="hidden";
	 }else{
	   //message d'erreur serveur
	   var erreurServeur="Erreur serveur : "+objetXHR.status+" – "+ objetXHR.statusText;
	   remplacerContenu("info", erreurServeur);
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   document.getElementById("charge").style.visibility="hidden";
	   //annule la requete en cours
	   objetXHR.abort();
	   objetXHR=null;
	   }
	 }
  }

//##############################MOTEUR AJAX 3############################################
function demandeGains() {   
 //création d'un objet XHR multi-navigateurs
 objetXHR3 = creationXHR();
 var temps = new Date().getTime();//création d'une variable temps pour l'anti-cache
 //construction de la chaine des parametres
 var parametres3 = "nom="+ codeContenu("nom") +
	 			   "&prenom="+ codeContenu("prenom") +
	               "&anticache="+temps ;
 //Config. objet XHR
 objetXHR3.open("get","gainListe.php?"+parametres3, true); 
 objetXHR3.onreadystatechange = afficheGains;//désignation de la fonction de rappel
 objetXHR3.send(null);//envoi de la requete
 }

function afficheGains() {
	if (objetXHR3.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR3.status == 200) {
	   listeJSON = objetXHR3.responseText;//recup du résulat > objet JSON
	   objetJSON3=listeJSON.parseJSON();
	   //créa des nouvelles lignes
	   var tableListe=document.getElementById("tableListe");
	   supprimerContenu(tableListe);
	   for(i=0;i<objetJSON3.gains.length;i++){
		 var montant=objetJSON3.gains[i].montant;
		 var date=objetJSON3.gains[i].date;
		 var ID=objetJSON3.gains[i].ID;
	     nouvelleLigne(tableListe,date,montant,ID);
	   }
	 }else{
	   //message d'erreur serveur
	   var erreurServeur="Erreur serveur : "+objetXHR3.status+" – "+ objetXHR3.statusText;
	   remplacerContenu("info", erreurServeur);
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   //annule la requete en cours
	   objetXHR3.abort();
	   objetXHR3=null;
	   }
	 }
  }
  //-----------------------------------------
function nouvelleLigne(tab,text1,text2,ID) { 
	   var nouveauTR=document.createElement('tr');
	   nouveauTR.setAttribute('id',ID); 
	   //-----------------------------------------
	   var nouveauTD1=document.createElement('td');
	   var nouveauTXT1=document.createTextNode(text1);
	   nouveauTD1.appendChild(nouveauTXT1);
	   var nouveauTD2=document.createElement('td');
	   var nouveauTXT2=document.createTextNode(text2);
	   nouveauTD2.onclick=function() {modeModif(nouveauTR,nouveauTD2,text2);}
	   nouveauTD2.appendChild(nouveauTXT2);
	   //------------------------------------------
	   nouveauTR.appendChild(nouveauTD1);
	   nouveauTR.appendChild(nouveauTD2);
	   //------------------------------------------
	   var nouveauTBODY=document.createElement('tbody');
	   nouveauTBODY.appendChild(nouveauTR);
	   tab.appendChild(nouveauTBODY);
}
//##############################MOTEUR AJAX 4############################################

function recupPrenoms(nom) {  
	 //reinitialise les options du menu 2 a chaque changement
	  document.getElementById("prenom").options.length = 1;
	 //cas ou il n'y a pas de nom sélectionné	
	 if (nom == "") return null ;
	 //--------------------
	 objetXHR4 = creationXHR();//création d'un objet XHR multi-navigateurs
	 var temps = new Date().getTime();//création d'une variable temps pour l'anti-cache
	 //construction de la chaine des parametres
	 var parametres = "nom="+ nom +
	                  "&anticache="+temps ;
	 //Config. objet XHR
     objetXHR4.open("get","prenomsListe.php?"+parametres, true); 
	 objetXHR4.onreadystatechange = creationMenu2;//désignation de la fonction de rappel
	 //gestion du bouton et du chargeur
     objetXHR4.send(null);//envoi de la requete
	 /*---------------------------------------- */
  }

function creationMenu2(){
	if (objetXHR4.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR4.status == 200) {
	   //recup du résulat au format TXT 
	   var nouveauResultat = objetXHR4.responseText;
	   //conversion de chaine JSON en objet JSON
	   var objetJSON=nouveauResultat.parseJSON();
	   //création du menu dans le DOM>>dans fonction de rappel
		for (i=0; i<objetJSON.listePrenoms.length; i++)
			{
			 var elementOption = document.createElement('option'); 
			 var texteOption = document.createTextNode(objetJSON.listePrenoms[i].prenom); 
			 elementOption.setAttribute('value',objetJSON.listePrenoms[i].prenom); 
			 elementOption.appendChild(texteOption); 
			 document.getElementById("prenom").appendChild(elementOption); 
			}
	}
	}
}
//##############################MOTEUR AJAX 5############################################

function modifGain(id,montant) {  
	 objetXHR5 = creationXHR();//création d'un objet XHR multi-navigateurs
	 var temps = new Date().getTime();//création d'une variable temps pour l'anti-cache
	 var parametres = "id="+ id +
	 				  "&montant="+ montant +
	                  "&anticache="+temps ;//construction de la chaine des parametres
	 objetXHR5.open("get","gainModif.php?"+parametres, true); //Config. objet XHR
	 objetXHR5.onreadystatechange = actualiseGain;//désignation de la fonction de rappel
     objetXHR5.send(null);//envoi de la requete
	 /*---------------------------------------- */
  }

function actualiseGain(){
	if (objetXHR5.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR5.status == 200) {
	   //recup du résulat au format TXT 
	   var nouveauResultat = objetXHR5.responseText;
	   if(nouveauResultat) demandeGains();
	   else alert("probleme technique");
		
	}
  }
}
//------------------------
function modeModif(elementTR,elementTD,valeurGain) {
	//-----Déclaration de idGain et elementInput en GLOBAL
	idGain=elementTR.getAttribute('ID');
	elementInput = document.createElement('input');
	//-----Config du champ de saisie elementInput
	with (elementInput) {
		setAttribute('type','text');
		setAttribute('name','gain');
		setAttribute('size','20');
		setAttribute('value',valeurGain);
		onkeypress=testEntree;
	}
	//-----Créa d'un cellule TD père de INPUT
	var nouveauTD = document.createElement("td");
    nouveauTD.appendChild(elementInput);
	//----Remplacement des deux cellules TD
	elementTR.replaceChild(nouveauTD,elementTD); 
}
function testEntree(event) {  
 	event = window.event||event;
    var codeTouche= event.keyCode; //récupération du code de la touche
    if(codeTouche==13) //test si touche Entrée
	{
	var nouveauGain=elementInput.value;//recup de la nouvelle valeur du gain
	modifGain(idGain,nouveauGain);//appel du moteur 5
	}
}
