--Chapitre8 Contrainte d'unicite (Fonction)
-- exemple classes associations basees sur les structures

--Fonction qui teste si le logiciel
--du departement n'est pas installe sur
--un autre serveur
CREATE OR REPLACE FUNCTION 
	contrainte_unicite(code_serv IN serveur.nomserv%TYPE,
	code_dept  departement.codedept%TYPE,
	code_logi  logiciel.codelogi%TYPE) RETURN BOOLEAN IS
	nom_serveur serveur.nomserv%TYPE;
	CURSOR postes_serveur
		IS SELECT nomserv FROM serveur
		WHERE nomserv <> code_serv;
	date_inst DATE;
BEGIN
	OPEN  postes_serveur;
	FETCH postes_serveur INTO nom_serveur;
	WHILE postes_serveur%FOUND LOOP
	BEGIN
	   SELECT nested_installs.dateinstall INTO date_inst
		  FROM  THE(SELECT installations FROM serveur
			WHERE nomserv = nom_serveur) nested_installs
		  WHERE nested_installs.dept.codedept = code_dept
		  AND nested_installs.logi.codelogi   = code_logi;
	   RETURN TRUE;
	   EXCEPTION
		WHEN NO_DATA_FOUND THEN
			FETCH postes_serveur INTO nom_serveur;
	END;
	END LOOP;
	CLOSE postes_serveur;
	RETURN FALSE;
END;
/

--Test de la fonction
CREATE TABLE temp(res VARCHAR(40));
BEGIN
IF (contrainte_unicite('Brassens','D2','log1')=TRUE) THEN
	insert into temp values ('Deja installe sur un autre serveur');
	ELSE
	insert into temp values ('Pas deja installe sur un autre serveur');
END IF;
END;
/
BEGIN
IF (contrainte_unicite('Brassens','D2','log2')=TRUE) THEN
	insert into temp values ('Deja installe sur un autre serveur');
	ELSE
	insert into temp values ('Pas deja installe sur un autre serveur');
END IF;
END;
/
SELECT * fROM temp;
drop table temp;