--Chapitre8 Contrainte d'unicite (Methode)
-- exemple classes associations basees sur les structures

--Methode installation d'un logiciel
CREATE OR REPLACE TYPE BODY serveur_type AS
 MEMBER PROCEDURE installe_logiciel(code_logi IN VARCHAR2,
				code_dept IN VARCHAR2, dinst IN DATE) IS
  trace          NUMBER;	
  reflogiciel    REF logiciel_type;
  refdept        REF departement_type;
   BEGIN
	trace := 1;
	--Le logiciel existe t-il?
	SELECT	REF(l) INTO reflogiciel
		FROM logiciel l
		WHERE l.codelogi  = code_logi;

	--Le departement existe t-il?
	trace := 2;
	SELECT	REF(d) INTO refdept
		FROM  departement d
		WHERE d.codedept  = code_dept;
	trace := 3;
	--Contrainte d'inclusion
	--Le logiciel a installe a t-il ete achete par le serveur
	SELECT	nested_achats.proprietaire INTO refdept
		FROM  THE(SELECT achats FROM logiciel 
			WHERE codelogi = code_logi) nested_achats
		WHERE nested_achats.proprietaire.codedept = code_dept;

	--Contrainte d'unicite
	--Le logiciel de ce departement
	--est-il deja installe sur un serveur different?
	IF (contrainte_unicite(SELF.nomserv,code_dept,code_logi)=TRUE) THEN
		RAISE_APPLICATION_ERROR(-20101,'Le logiciel ' || code_logi ||
		 ' du departement ' || code_dept || ' est deja installe sur un serveur ');
	ELSE
	--Installation du logiciel
		INSERT INTO
		THE(SELECT installations FROM serveur WHERE nomserv = SELF.nomserv)
		SELECT dinst,REF(d),REF(l)
			FROM departement d, logiciel l
			WHERE d.codedept = code_dept
			AND l.codelogi   = code_logi;
	END IF;
	
  EXCEPTION
	WHEN NO_DATA_FOUND THEN 
	IF (trace = 1) THEN
	 RAISE_APPLICATION_ERROR(-20101,'Le logiciel ' 
	|| code_logi || ' n''est pas reference dans la base');
	END IF;
	IF (trace = 2) THEN
	 RAISE_APPLICATION_ERROR(-20101,'Le departement ' 
	|| code_dept || ' n''est pas reference dans la base');
	END IF;
	IF (trace = 3) THEN
	 RAISE_APPLICATION_ERROR(-20101,'Le departement ' 
	|| code_dept || ' n''a pas achete le logiciel ' || code_logi);
	END IF;
  END installe_logiciel;
 END;
/

--Appel de la methode
--Avant
SELECT nt.dateinstall,nt.dept.codedept,nt.logi.codelogi
	FROM THE(SELECT installations FROM serveur 
		WHERE nomserv = 'Brassens') nt;
SELECT nt.dateinstall,nt.dept.codedept,nt.logi.codelogi
	FROM THE(SELECT installations FROM serveur 
		WHERE nomserv = 'Nougaro') nt;

DECLARE
	inst_serv serveur_type;
BEGIN
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Brassens';
	inst_serv.installe_logiciel('log1','D1','13-05-95');
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Nougaro';
	inst_serv.installe_logiciel('log1','D2','15-05-95');
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Brassens';
	inst_serv.installe_logiciel('log2','D2','16-05-95');
END;
/

--Apres
SELECT nt.dateinstall,nt.dept.codedept,nt.logi.codelogi
	FROM THE(SELECT installations FROM serveur 
		WHERE nomserv = 'Brassens') nt;
SELECT nt.dateinstall,nt.dept.codedept,nt.logi.codelogi
	FROM THE(SELECT installations FROM serveur 
		WHERE nomserv = 'Nougaro') nt;

--Essais d'erreurs
--Erreur due a la contrainte d'inclusion
DECLARE
	inst_serv serveur_type;
BEGIN
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Nougaro';
	inst_serv.installe_logiciel('log3','D1','13-05-95');
END;
/
--Erreur due a la contrainte d'unicite
DECLARE
	inst_serv serveur_type;
BEGIN
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Brassens';
	inst_serv.installe_logiciel('log1','D2','13-05-95');
END;
/

--Suppressions
DROP TABLE serveur;
DROP TABLE logiciel;
DROP TABLE  departement;

DROP TYPE serveur_type;
DROP TYPE installations_type;
DROP TYPE installation_type;
DROP TYPE logiciel_type;
DROP TYPE achats_type;
DROP TYPE achat_type;
DROP TYPE departement_type;
