-- Chap8  Contrainte de simultaneite

drop table pilote;
drop table entrainement;
drop table sanitaire;

drop type pilote_type;
drop type entrainement_type;
drop type sanitaire_type;
CREATE TYPE sanitaire_type AS OBJECT
 (codesan varchar(10), organisme varchar(20))
/
CREATE TYPE entrainement_type AS OBJECT
 (codent varchar(10), datent DATE, region varchar(20))
/
CREATE TYPE pilote_type AS OBJECT
 (numpil NUMBER, nom varchar(10), grade varchar(10), 
  sani REF sanitaire_type, entraine REF entrainement_type,
  MEMBER PROCEDURE rattache_sani_ent(missionsani IN varchar,missionentraine IN varchar),
  PRAGMA RESTRICT_REFERENCES(rattache_sani_ent,RNPS,WNPS),
  MEMBER PROCEDURE detache_sani_ent,
  PRAGMA RESTRICT_REFERENCES(detache_sani_ent,RNPS,WNPS))
/
CREATE TABLE sanitaire OF sanitaire_type 
 (constraint pk_sanitaire primary key(codesan));
CREATE TABLE entrainement OF entrainement_type
 (constraint pk_entraine primary key(codent));
CREATE TABLE pilote  OF pilote_type
 (constraint pk_pilote primary key(numpil));


--Trigger
CREATE OR REPLACE TRIGGER T_I_VERIF_PILOTE
	AFTER INSERT ON pilote
	FOR EACH ROW
BEGIN
IF ((:new.sani IS NOT NULL OR :new.entraine IS NULL) 
   OR (:new.sani IS NULL OR :new.entraine IS NOT NULL)) THEN
	RAISE_APPLICATION_ERROR(-20101,'Le pilote ' || TO_CHAR(:new.numpil) || ' 
	ne peut pas etre affecte a une seule mission');
END IF;
END;
/

--
insert into sanitaire values ('ONU1','ONU en Bosnie');
insert into sanitaire values ('ONU2','ONU au Congo');
insert into entrainement values ('ENT1',SYSDATE-2,'Pays basque');
insert into entrainement values ('ENT2',SYSDATE,'Toulouse Sud');
insert into entrainement values ('ENT3',SYSDATE,'Salon de Provence');

insert into pilote values(1,'B. Danny','Colonel',NULL,NULL);
insert into pilote values(2,'Tanguy','Colonel',NULL,NULL);
insert into pilote values(3,'Laverdure','Capitaine',NULL,NULL);

--
SELECT * FROM sanitaire;
SELECT * FROM entrainement;
SELECT	p.numpil, p.nom, p.grade	
	FROM pilote p
	WHERE p.sani IS NULL
	AND p.entraine IS NULL;
