--Corrige exo 5.3 schema physique 1
-- liens multivalues et structures

--Creation des types et des tables
CREATE TYPE bureau1_type
/
CREATE TYPE local_type AS OBJECT (local REF bureau1_type)
/
CREATE TYPE locaux_type AS TABLE OF local_type
/
CREATE TYPE segment1_type AS OBJECT
 (ind_IP varchar2(11), longueur number, locaux locaux_type)
/
CREATE TYPE segREF_type AS OBJECT (seg REF segment1_type)
/
CREATE TYPE segments_type AS TABLE OF segREF_type
/
CREATE TYPE poste_travail1_type
/
CREATE TYPE posteREF_type AS OBJECT (poste_t REF poste_travail1_type)
/
CREATE TYPE equipements_type AS TABLE OF posteREF_type
/
CREATE OR REPLACE TYPE bureau1_type AS OBJECT
 (nbureau varchar2(5), capacite number, etage number,
  segments segments_type, equipements equipements_type);
/
CREATE OR REPLACE TYPE poste_travail1_type AS OBJECT
 (nserie varchar2(5), adrIP varchar2(3), typeposte varchar2(8),
  connexion    REF segment1_type,
  localisation REF bureau1_type)
/
CREATE TYPE installe_type AS OBJECT
 (dateinst date, poste REF poste_travail1_type)
/
CREATE TYPE installations_type AS TABLE OF installe_type
/
CREATE TYPE logiciel1_type AS OBJECT
 (codelogi varchar2(5), nomlogi varchar2(10),
  version varchar2(10), dateachat date,
  typeOS varchar2(8), installations installations_type)
/

CREATE TABLE bureau1 OF bureau1_type
 (CONSTRAINT pk_bureau1 PRIMARY KEY(nbureau))
  NESTED TABLE segments STORE AS tabsegments,
  NESTED TABLE equipements STORE AS tabpostes;

CREATE TABLE segment1 OF segment1_type
 (CONSTRAINT pk_segment1 PRIMARY KEY(ind_IP))
  NESTED TABLE locaux STORE AS tablocaux;

CREATE TABLE poste_travail1 OF poste_travail1_type
 (CONSTRAINT pk_poste_travail1 PRIMARY KEY(nserie));

CREATE TABLE logiciel1 OF logiciel1_type
 (CONSTRAINT pk_logiciel1 PRIMARY KEY(codelogi))
 NESTED TABLE installations STORE AS tabinstallations;


--Suppression des tables et des types
DROP TABLE logiciel1;
DROP TABLE poste_travail1;
DROP TABLE segment1;
DROP TABLE bureau1;

DROP TYPE logiciel1_type;
DROP TYPE installations_type;
DROP TYPE installe_type;
DROP TYPE poste_travail1_type FORCE;
DROP TYPE bureau1_type FORCE;
DROP TYPE equipements_type;
DROP TYPE posteREF_type;
DROP TYPE segments_type;
DROP TYPE segREF_type;
DROP TYPE segment1_type;
DROP TYPE locaux_type;
DROP TYPE local_type;

