-- Corrige 8.1
-- Installations d'un logiciel sur les postes d'un segment
--SCHEMA 1

--Modification du type : declaration de la methode
ALTER TYPE segment1_type REPLACE AS OBJECT
 (ind_IP varchar2(11), longueur number, locaux locaux_type,
  MEMBER PROCEDURE installe_logiciel_segment(clog IN varchar2,
	nomlog IN varchar2, verlog IN varchar2, datlog IN date,
	typlog IN varchar2),
  PRAGMA RESTRICT_REFERENCES(installe_logiciel_segment,RNPS,WNPS))
/

--Table optionnelle et temporaire qui permet de tracer les operations
DROP TABLE compte_rendu;
CREATE TABLE compte_rendu (message VARCHAR(80));

--Corps de la methode
CREATE OR REPLACE TYPE BODY segment1_type AS
MEMBER PROCEDURE installe_logiciel_segment(clog IN varchar2,
	nomlog IN varchar2, verlog IN varchar2, datlog IN date,
	typlog IN varchar2)
IS
	CURSOR c1 IS SELECT p.nserie
		FROM poste_travail1 p
		WHERE p.typeposte = typlog
		AND p.connexion.ind_IP = SELF.ind_IP;
	c1_rec c1%ROWTYPE;
BEGIN
	--Enregistrement du nouveau logiciel
	INSERT INTO logiciel1 VALUES
	(clog,nomlog,verlog,datlog,typlog,installations_type());
	INSERT INTO compte_rendu VALUES
	('Enregistrement de ' || clog || ' dans logiciel1');

	-- Recuperation des postes du segment concerns par l'install	
	FOR c1_rec IN c1 LOOP
	   INSERT INTO 
		THE (SELECT installations
			FROM logiciel1 WHERE codelogi = clog)
		SELECT SYSDATE,REF(p)	FROM poste_travail1 p
					WHERE p.nserie = c1_rec.nserie;
	   INSERT INTO compte_rendu VALUES
	   ('Installation sur '||c1_rec.nserie);
	END LOOP;
	
	INSERT INTO compte_rendu VALUES('Transaction termine ....');
	COMMIT;
END installe_logiciel_segment;
END;
/

--Appel de la methode

--Avant appel
SELECT * FROM compte_rendu;
SELECT codelogi,nomlogi,version,dateachat,typeOS FROM logiciel1;
SELECT nlog9.dateinst, nlog9.poste.nserie
	FROM THE (SELECT installations
	FROM logiciel1 WHERE codelogi = 'log9') nlog9;


DECLARE
	segment_a_installer segment1_type;
BEGIN
	SELECT	VALUE(s) INTO segment_a_installer
		FROM segment1 s
		WHERE s.ind_IP = '130.40.30';
	segment_a_installer.installe_logiciel_segment('log9',
		'Powerpoint','97',TO_DATE('14-08-98'),'Win95');
END;
/


--Apres appel
SELECT * FROM compte_rendu;
SELECT codelogi,nomlogi,version,dateachat,typeOS FROM logiciel1;
SELECT nlog9.dateinst, nlog9.poste.nserie
	FROM THE (SELECT installations
	FROM logiciel1 WHERE codelogi = 'log9') nlog9;


--Solution en Bloc PL/SQL
DROP TABLE compte_rendu;
CREATE TABLE compte_rendu (message VARCHAR(80));

DECLARE 
	clog logiciel1.codelogi%TYPE;
	nomlog logiciel1.nomlogi%TYPE;
	verlog logiciel1.version%TYPE;
	datlog logiciel1.dateachat%TYPE;
	typlog logiciel1.typeOS%TYPE;
	CURSOR c1 IS SELECT p.nserie
		FROM poste_travail1 p
		WHERE p.typeposte = typlog
		AND p.connexion.ind_IP = '130.40.30';
	c1_rec c1%ROWTYPE;
--SELF.ind_IP;
BEGIN
	clog := 'log9';
	nomlog := 'Powerpoint';
	verlog := '97';
	datlog := TO_DATE('14-08-98');
	typlog := 'Win95';
	--Enregistrement du nouveau logiciel
	INSERT INTO logiciel1 VALUES
	(clog,nomlog,verlog,datlog,typlog,installations_type());
	INSERT INTO compte_rendu VALUES
	('Enregistrement de ' || clog || ' dans logiciel1');

	-- Recuperation des postes du segment concerns par l'install	
	FOR c1_rec IN c1 LOOP
	   INSERT INTO 
		THE (SELECT installations
			FROM logiciel1 WHERE codelogi = clog)
		SELECT SYSDATE,REF(p) FROM poste_travail1 p
				WHERE p.nserie = c1_rec.nserie;
		
	   INSERT INTO compte_rendu VALUES
	   ('Installation sur '||c1_rec.nserie);
	END LOOP;
	
	INSERT INTO compte_rendu VALUES
	('Transaction termine ....');
	-- COMMIT;
END;
/

SELECT * FROM compte_rendu;
SELECT codelogi,nomlogi,version,dateachat,typeOS FROM logiciel1;

SELECT nlog9.dateinst, nlog9.poste.nserie
	FROM THE (SELECT installations
	FROM logiciel1 WHERE codelogi = 'log9') nlog9;

DROP TABLE compte_rendu;
