-- Chap8  Contrainte d'inclusion (Procedure)

CREATE OR REPLACE PROCEDURE 
	saisie_voeux(qui IN VARCHAR ,quoi IN NUMBER) IS
trace          NUMBER;	
refstage    REF stage_type;
refetudiant REF etudiant_type;
BEGIN
	trace := 1;
	SELECT	REF(e)INTO refetudiant
		FROM etudiant e
		WHERE e.ninsee  = qui;
	trace := 2;
	SELECT	REF(s) INTO refstage
		FROM  stage s
		WHERE s.numsta  = quoi;

	INSERT INTO voeux
		SELECT REF(e),REF(s)
		FROM etudiant e, stage s
		WHERE e.ninsee = qui
		AND  s.numsta = quoi;
  EXCEPTION
	WHEN NO_DATA_FOUND THEN 
	IF (trace = 1) THEN
	 RAISE_APPLICATION_ERROR(-20101,'L''etudiant ' || qui || 
		' n''est pas reference dans la base...');		
	END IF;
	IF (trace = 2) THEN
	RAISE_APPLICATION_ERROR(-20101,'Le stage ' || quoi ||
		' n''est pas reference dans la base...');		
	END IF;
END;
/

--
delete from etudiant;
delete from stage;
delete from voeux;
insert into etudiant values ('1650275062009','Mercier');
insert into etudiant values ('1450258964125','Hait');
insert into stage values (1,'Electronique','Allegre',NULL);
insert into stage values (2,'Bases de donnees','Gardarin',NULL);
insert into stage values (3,'Probabilites','Leibnitz',NULL);

SELECT * FROM etudiant;
SELECT numsta,theme,responsable FROM stage;
SELECT * FROM voeux;

--Inscription des voeux
BEGIN
	saisie_voeux('1650275062009',1);
	saisie_voeux('1650275062009',2);
	saisie_voeux('1450258964125',2);
	saisie_voeux('1450258964125',3);
END;
/
SELECT	v.etud.nom "ETUDIANT",
	v.stag.numsta "STAGE"
	FROM voeux v;

-- Voeux incorrect
BEGIN
	saisie_voeux('1450258964125',5);
END;
/
-- Voeux incorrects
BEGIN
	saisie_voeux('00',2);
END;
/