-- Chap8  Contrainte de Partition (creation des objets)

CREATE TYPE sanitaire_type AS OBJECT
 (codesan varchar(10), organisme varchar(20))
/
CREATE TYPE entrainement_type AS OBJECT
 (codent varchar(10), datent DATE, region varchar(20))
/
CREATE TYPE pilote_type AS OBJECT
 (numpil NUMBER, nom varchar(10), grade varchar(10), 
  sani REF sanitaire_type, entraine REF entrainement_type,
  MEMBER PROCEDURE rattache_sanitaire(missionsani IN varchar),
  PRAGMA RESTRICT_REFERENCES(rattache_sanitaire,RNPS,WNPS),
  MEMBER PROCEDURE rattache_entrainement(missionentraine IN varchar),
  PRAGMA RESTRICT_REFERENCES(rattache_entrainement,RNPS,WNPS))
/
CREATE TABLE sanitaire OF sanitaire_type 
 (constraint pk_sanitaire primary key(codesan));
CREATE TABLE entrainement OF entrainement_type
 (constraint pk_entraine primary key(codent));
CREATE TABLE pilote  OF pilote_type
 (constraint pk_pilote primary key(numpil));

--
insert into sanitaire values ('ONU1','ONU en Bosnie');
insert into sanitaire values ('ONU2','ONU au Congo');
insert into entrainement values ('ENT1','20-12-98','Pays basque');
insert into entrainement values ('ENT2','22-12-98','Toulouse Sud');
insert into entrainement values ('ENT3','22-12-98','Salon de Provence');

insert into pilote values(1,'B. Danny','Colonel',NULL,NULL);
insert into pilote values(2,'Tanguy','Colonel',NULL,NULL);
insert into pilote values(3,'Laverdure','Capitaine',NULL,NULL);

--
SELECT * FROM sanitaire;
SELECT * FROM entrainement;
SELECT	p.numpil, p.nom, p.grade	
	FROM pilote p
	WHERE p.sani IS NULL
	AND p.entraine IS NULL;

	
-- Suppression des objets
drop table pilote;
drop table entrainement;
drop table sanitaire;

drop type pilote_type;
drop type entrainement_type;
drop type sanitaire_type;