-- Chap8  Sans contrainte (appels des methodes)

--Avant
SELECT	nt_ONU1.pilsani.numpil "Pilotes de ONU1",
	nt_ONU1.pilsani.nom  "Nom" FROM 
	THE(SELECT contingent
		FROM sanitaire s
		WHERE s.codesan = 'ONU1') nt_ONU1;

SELECT	nt_ENT2.pilent.numpil "Pilotes de ENT2"	,
	nt_ENT2.pilent.nom  "Nom" FROM 
	THE(SELECT equipe
		FROM entrainement e
		WHERE e.codent = 'ENT2') nt_ENT2;

-- Appel de la procedure par PL/SQL
DECLARE
	pilote_a_affecter pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote_a_affecter
		FROM pilote p
		WHERE p.numpil = 1;
	pilote_a_affecter.rattache_sanitaire('ONU1');
	SELECT	VALUE(p) INTO pilote_a_affecter 
		FROM pilote p
		WHERE p.numpil = 2;
	pilote_a_affecter.rattache_entrainement('ENT2');
	SELECT	VALUE(p) INTO pilote_a_affecter
		FROM pilote p
		WHERE p.numpil = 3;
	pilote_a_affecter.rattache_entrainement('ENT2');
END;
/
--Apres
SELECT	nt_ONU1.pilsani.numpil "Pilotes de ONU1",
	nt_ONU1.pilsani.nom  "Nom" FROM 
	THE(SELECT contingent
		FROM sanitaire s
		WHERE s.codesan = 'ONU1') nt_ONU1;

SELECT	nt_ENT2.pilent.numpil "Pilotes de ENT2"	,
	nt_ENT2.pilent.nom  "Nom" FROM 
	THE(SELECT equipe
		FROM entrainement e
		WHERE e.codent = 'ENT2') nt_ENT2;


-- Appel des methodes par PL/SQL
DECLARE
	pilote_a_muter pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote_a_muter
		FROM pilote p
		WHERE p.numpil = 1;
	pilote_a_muter.detache_sanitaire('ONU1');
	pilote_a_muter.rattache_entrainement('ENT1');
	SELECT	VALUE(p) INTO pilote_a_muter
		FROM pilote p
		WHERE p.numpil = 3;
	pilote_a_muter.detache_entrainement('ENT2');
	pilote_a_muter.rattache_entrainement('ENT1');
	pilote_a_muter.rattache_sanitaire('ONU2');
END;
/

--Apres
SELECT	nt_ONU1.pilsani.numpil "Pilotes de ONU1",
	nt_ONU1.pilsani.nom  "Nom" FROM 
	THE(SELECT contingent
		FROM sanitaire s
		WHERE s.codesan = 'ONU1') nt_ONU1;

SELECT	nt_ONU2.pilsani.numpil "Pilotes de ONU2",
	nt_ONU2.pilsani.nom  "Nom" FROM 
	THE(SELECT contingent
		FROM sanitaire s
		WHERE s.codesan = 'ONU2') nt_ONU2;

SELECT	nt_ENT1.pilent.numpil "Pilotes de ENT1"	,
	nt_ENT1.pilent.nom  "Nom" FROM 
	THE(SELECT equipe
		FROM entrainement e
		WHERE e.codent = 'ENT1') nt_ENT1;

SELECT	nt_ENT2.pilent.numpil "Pilotes de ENT2"	,
	nt_ENT2.pilent.nom  "Nom" FROM 
	THE(SELECT equipe
		FROM entrainement e
		WHERE e.codent = 'ENT2') nt_ENT2;


DROP TABLE entrainement;
DROP TABLE sanitaire;
DROP TABLE pilote;

DROP TYPE entrainement_type;
DROP TYPE equipe_type;
DROP TYPE pilentREF_type;
DROP TYPE sanitaire_type;
DROP TYPE contingent_type;
DROP TYPE pilsaniREF_type;
DROP TYPE pilote_type;