-- Chap8  Sans contrainte (declaration des tables)

CREATE TYPE pilote_type AS OBJECT
 (numpil NUMBER, nom varchar(10), grade varchar(10),
  MEMBER PROCEDURE rattache_sanitaire(missionsani IN varchar),
  PRAGMA RESTRICT_REFERENCES(rattache_sanitaire,RNPS,WNPS),
  MEMBER PROCEDURE detache_sanitaire(missionsani IN varchar),
  PRAGMA RESTRICT_REFERENCES(detache_sanitaire,RNPS,WNPS),
  MEMBER PROCEDURE rattache_entrainement(missionentraine IN varchar),
  PRAGMA RESTRICT_REFERENCES(rattache_entrainement,RNPS,WNPS),
  MEMBER PROCEDURE detache_entrainement(missionentraine IN varchar),
  PRAGMA RESTRICT_REFERENCES(detache_entrainement,RNPS,WNPS))
/
CREATE TYPE pilsaniREF_type AS OBJECT
 (pilsani REF pilote_type)
/
CREATE TYPE contingent_type AS TABLE OF pilsaniREF_type
/
CREATE TYPE sanitaire_type AS OBJECT
 (codesan varchar(10), organisme varchar(20),
  contingent contingent_type)
/
CREATE TYPE pilentREF_type AS OBJECT
 (pilent REF pilote_type)
/
CREATE TYPE equipe_type AS TABLE OF pilentREF_type
/
CREATE TYPE entrainement_type AS OBJECT
 (codent varchar(10), datent DATE, region varchar(20),
  equipe equipe_type)
/
CREATE TABLE pilote  OF pilote_type
 (CONSTRAINT pk_pilote PRIMARY KEY(numpil));

CREATE TABLE sanitaire OF sanitaire_type 
 (CONSTRAINT pk_sanitaire PRIMARY KEY(codesan))
  NESTED TABLE contingent STORE AS tabcontingent;

CREATE TABLE entrainement OF entrainement_type
 (CONSTRAINT pk_entraine PRIMARY KEY(codent))
  NESTED TABLE equipe STORE AS tabequipe;

--
delete from sanitaire;
delete from entrainement;
delete from pilote;
insert into sanitaire values ('ONU1','ONU en Bosnie',contingent_type());
insert into sanitaire values ('ONU2','ONU au Congo',contingent_type());
insert into entrainement values ('ENT1','20-12-98','Pays basque',equipe_type());
insert into entrainement values ('ENT2','22-12-98','Toulouse Sud',equipe_type());
insert into entrainement values ('ENT3','22-12-98','Salon de Provence',equipe_type());
INSERT INTO pilote VALUES(1,'B. Danny','Colonel');
INSERT INTO pilote VALUES(2,'Tanguy','Colonel');
INSERT INTO pilote VALUES(3,'Laverdure','Capitaine');

--
SELECT * FROM sanitaire;
SELECT * FROM entrainement;
SELECT	* FROM pilote;
