--Chapitre5 ex Association d'associations

CREATE OR REPLACE TYPE departement_type AS OBJECT
 (codedept varchar2(10), nomdept varchar2(20))
/
CREATE OR REPLACE TYPE achat_type AS OBJECT
 (dateachat date,
  proprietaire REF departement_type)
/
CREATE OR REPLACE TYPE achats_type AS TABLE OF achat_type
/
CREATE OR REPLACE TYPE logiciel_type AS OBJECT
 (codelogi varchar2(5),
  nomlogi varchar2(10),
  achats achats_type)
/
CREATE OR REPLACE TYPE installation_type AS OBJECT
 (dateinstall date,
  dept REF departement_type,
  logi REF logiciel_type)
/
CREATE OR REPLACE TYPE installations_type 
AS TABLE OF installation_type;
/
CREATE OR REPLACE TYPE serveur_type AS OBJECT
 (nomserv varchar2(10), typeserv varchar2(15),
  installations installations_type)
/
CREATE TABLE departement OF departement_type
 (CONSTRAINT pk_dept PRIMARY KEY(codedept));

CREATE TABLE logiciel OF logiciel_type
 (CONSTRAINT pk_logi PRIMARY KEY(codelogi))
 NESTED TABLE achats STORE AS tabachs;

CREATE TABLE serveur OF serveur_type
 (CONSTRAINT pk_serv PRIMARY KEY(nomserv))
 NESTED TABLE installations STORE AS tabinsts;

--Suppressions
DROP TABLE serveur;
DROP TABLE logiciel;
DROP TABLE  departement;

DROP TYPE serveur_type;
DROP TYPE installations_type;
DROP TYPE installation_type;
DROP TYPE logiciel_type;
DROP TYPE achats_type;
DROP TYPE achat_type;
DROP TYPE departement_type;
