--Chap8 Contrainte d'unicite (creation des tables)
-- exemple classes-associations solutions universelles

CREATE OR REPLACE TYPE departement_type AS OBJECT
 (codedept varchar2(10), nomdept varchar2(20))
/
CREATE OR REPLACE TYPE logiciel_type AS OBJECT
 (codelogi varchar2(5), nomlogi varchar2(10))
/
CREATE OR REPLACE TYPE achat_type AS OBJECT
 (dateachat date, dept REF departement_type,
  logi REF logiciel_type)
/
CREATE OR REPLACE TYPE serveur_type AS OBJECT
 (nomserv varchar2(10), typeserv varchar2(15),
  MEMBER PROCEDURE installe_logiciel(code_logi IN VARCHAR2,
	code_dept IN VARCHAR2, dinst IN DATE),
  PRAGMA RESTRICT_REFERENCES(installe_logiciel,RNPS,WNPS))
/
CREATE OR REPLACE TYPE installation_type AS OBJECT
 (dateinstall date, ach REF achat_type,
  serv REF serveur_type)
/

CREATE TABLE departement OF departement_type
 (CONSTRAINT pk_dept PRIMARY KEY(codedept));

CREATE TABLE logiciel OF logiciel_type
 (CONSTRAINT pk_logi PRIMARY KEY(codelogi));

CREATE TABLE achat OF achat_type
 (CONSTRAINT nn_logi logi NOT NULL,
  CONSTRAINT nn_dept dept NOT NULL);

CREATE TABLE serveur OF serveur_type
 (CONSTRAINT pk_serv PRIMARY KEY(nomserv));

CREATE TABLE installation OF installation_type
 (CONSTRAINT nn_ach ach NOT NULL,
  CONSTRAINT nn_serv serv NOT NULL);

--
DELETE FROM installation;
DELETE FROM serveur;
DELETE FROM achat;
DELETE FROM departement;
DELETE FROM logiciel;

INSERT INTO logiciel VALUES ('log1','Oracle7');
INSERT INTO logiciel VALUES ('log2','Oracle7');
INSERT INTO logiciel VALUES ('log3','Oracle8');

INSERT INTO departement VALUES ('D1','G.T.R');
INSERT INTO departement VALUES ('D2','Informatique');

INSERT INTO serveur VALUES ('Brassens','PC Linux');
INSERT INTO serveur VALUES ('Nougaro','HP 700');
INSERT INTO serveur VALUES ('Icare','Sun Sparc 20');
INSERT INTO serveur VALUES ('Brel','NT 4');

--Chargement de la table achats
INSERT INTO achat
	SELECT '13-05-95',REF(d),REF(l)
	FROM departement d, logiciel l
	WHERE d.codedept = 'D1' AND l.codelogi = 'log1';
INSERT INTO achat
	SELECT '15-05-95',REF(d),REF(l)
	FROM departement d, logiciel l
	WHERE d.codedept = 'D2' AND l.codelogi = 'log1';
INSERT INTO achat
	SELECT '15-05-95',REF(d),REF(l)
	FROM departement d, logiciel l
	WHERE d.codedept = 'D2' AND l.codelogi = 'log2';
INSERT INTO achat
	SELECT '16-09-98',REF(d),REF(l)
	FROM departement d, logiciel l
	WHERE d.codedept = 'D2' AND l.codelogi = 'log3';

--
SELECT	* FROM logiciel;
SELECT	* FROM departement;
SELECT	* FROM serveur;

SELECT	a.logi.codelogi "Logi.",
	a.dept.codedept "Dept.",
	a.dateachat "Achat"
	FROM achat a;