--Chap8 Contrainte d'unicite (methode)
-- exemple classes-associations solutions universelles

--Methode installation d'un logiciel
CREATE OR REPLACE TYPE BODY serveur_type AS
 MEMBER PROCEDURE installe_logiciel(code_logi IN VARCHAR2,
				code_dept IN VARCHAR2, dinst IN DATE) IS
  trace          NUMBER;	
  reflogiciel    REF logiciel_type;
  refdept        REF departement_type;
  refachat       REF achat_type;
  nom_serv       serveur.nomserv%TYPE;
   BEGIN
	--Le logiciel existe t-il?
	trace := 1;
	SELECT	REF(l) INTO reflogiciel
		FROM logiciel l
		WHERE l.codelogi  = code_logi;
	--Le departement existe t-il?
	trace := 2;
	SELECT	REF(d) INTO refdept
		FROM  departement d
		WHERE d.codedept  = code_dept;

	--Contrainte d'inclusion
	--Le logiciel a installe a t-il ete achete par le serveur
	trace := 3;
	SELECT	REF(a) INTO refachat FROM achat a
		WHERE a.logi.codelogi = code_logi
		AND   a.dept.codedept = code_dept;

	--Contrainte d'unicite
	--Le logiciel de ce departement
	--est-il deja installe sur un serveur different?
	trace := 4;
	SELECT	i.serv.nomserv INTO nom_serv FROM installation i
		WHERE i.serv.nomserv <> SELF.nomserv
		AND   i.ach.logi.codelogi = code_logi
		AND   i.ach.dept.codedept = code_dept;
	RAISE_APPLICATION_ERROR(-20101,'Le logiciel ' || code_logi ||
		 ' du departement ' || code_dept || ' est deja installe sur le serveur '
		|| nom_serv);
   EXCEPTION
	WHEN NO_DATA_FOUND THEN 
	IF (trace = 1) THEN
	 RAISE_APPLICATION_ERROR(-20101,'Le logiciel ' 
	|| code_logi || ' n''est pas reference dans la base');
	END IF;
	IF (trace = 2) THEN
	 RAISE_APPLICATION_ERROR(-20101,'Le departement ' 
	|| code_dept || ' n''est pas reference dans la base');
	END IF;
	IF (trace = 3) THEN
	 RAISE_APPLICATION_ERROR(-20101,'Le departement ' 
	|| code_dept || ' n''a pas achete le logiciel ' || code_logi);
	END IF;
	IF (trace = 4) THEN
	--Installation du logiciel
	INSERT INTO installation
		SELECT	dinst,refachat,REF(s)
			FROM serveur s
			WHERE s.nomserv = SELF.nomserv;
	END IF;
  END installe_logiciel;
 END;
/

--Appel de la methode
--Avant
SELECT	i.ach.logi.codelogi "Logi.",
	i.ach.dept.codedept "Dept.",
	i.serv.nomserv "Serveur"
	FROM installation i;

DECLARE
	inst_serv serveur_type;
BEGIN
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Brassens';
	inst_serv.installe_logiciel('log1','D1','13-05-95');
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Nougaro';
	inst_serv.installe_logiciel('log1','D2','15-05-95');
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Brassens';
	inst_serv.installe_logiciel('log2','D2','16-05-95');
END;
/

--Apres
SELECT	i.ach.logi.codelogi "Logi.",
	i.ach.dept.codedept "Dept.",
	i.serv.nomserv "Serveur"
	FROM installation i;


--Essais d'erreurs
--Erreur due a la contrainte d'inclusion
DECLARE
	inst_serv serveur_type;
BEGIN
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Nougaro';
	inst_serv.installe_logiciel('log3','D1','13-05-95');
END;
/
--Erreur due a la contrainte d'unicite
DECLARE
	inst_serv serveur_type;
BEGIN
	SELECT	VALUE(s) INTO inst_serv
		FROM serveur s
		WHERE s.nomserv = 'Brassens';
	inst_serv.installe_logiciel('log1','D2','13-05-95');
END;
/

--Suppressions
DROP TABLE departement;
DROP TABLE logiciel;
DROP TABLE achat;
DROP TABLE serveur;
DROP TABLE installation;

DROP TYPE installation_type;
DROP TYPE serveur_type;
DROP TYPE achat_type;
DROP TYPE logiciel_type;
DROP TYPE departement_type;


