--Chapitre8 Contrainte d'unicite (creation des tables)
-- exemple classes associations basees sur les structures

CREATE OR REPLACE TYPE departement_type AS OBJECT
 (codedept varchar2(10), nomdept varchar2(20))
/
CREATE OR REPLACE TYPE achat_type AS OBJECT
 (dateachat date, proprietaire REF departement_type)
/
CREATE OR REPLACE TYPE achats_type AS TABLE OF achat_type
/
CREATE OR REPLACE TYPE logiciel_type AS OBJECT
 (codelogi varchar2(5), nomlogi varchar2(10),
  achats achats_type)
/
CREATE OR REPLACE TYPE installation_type AS OBJECT
 (dateinstall date, dept REF departement_type,
  logi REF logiciel_type)
/
CREATE OR REPLACE TYPE installations_type 
AS TABLE OF installation_type;
/
CREATE OR REPLACE TYPE serveur_type AS OBJECT
 (nomserv varchar2(10), typeserv varchar2(15),
  installations installations_type,
  MEMBER PROCEDURE installe_logiciel(code_logi IN VARCHAR2,
	code_dept IN VARCHAR2,dinst IN DATE),
  PRAGMA RESTRICT_REFERENCES(installe_logiciel,RNPS,WNPS))
/
CREATE TABLE departement OF departement_type
 (CONSTRAINT pk_dept PRIMARY KEY(codedept));

CREATE TABLE logiciel OF logiciel_type
 (CONSTRAINT pk_logi PRIMARY KEY(codelogi))
 NESTED TABLE achats STORE AS tabachs;

CREATE TABLE serveur OF serveur_type
 (CONSTRAINT pk_serv PRIMARY KEY(nomserv))
 NESTED TABLE installations STORE AS tabinsts;

--
DELETE FROM serveur;
DELETE FROM departement;
DELETE FROM logiciel;

INSERT INTO logiciel VALUES ('log1','Oracle7',achats_type());
INSERT INTO logiciel VALUES ('log2','Oracle7',achats_type());
INSERT INTO logiciel VALUES ('log3','Oracle8',achats_type());

INSERT INTO departement VALUES ('D1','G.T.R');
INSERT INTO departement VALUES ('D2','Informatique');

INSERT INTO serveur VALUES ('Brassens','PC Linux',installations_type());
INSERT INTO serveur VALUES ('Nougaro','HP 700',installations_type());
INSERT INTO serveur VALUES ('Icare','Sun Sparc 20',installations_type());
INSERT INTO serveur VALUES ('Brel','NT 4',installations_type());


--Chargement de la table achats
INSERT INTO
	THE(SELECT achats FROM logiciel	WHERE codelogi = 'log1')
	SELECT '13-5-95',REF(d)
	FROM departement d
	WHERE d.codedept = 'D1';
INSERT INTO
	THE(SELECT achats FROM logiciel	WHERE codelogi = 'log1')
	SELECT '15-5-95',REF(d)
	FROM departement d
	WHERE d.codedept = 'D2';
INSERT INTO
	THE(SELECT achats FROM logiciel	WHERE codelogi = 'log2')
	SELECT '15-5-95',REF(d)
	FROM departement d
	WHERE d.codedept = 'D2';
INSERT INTO
	THE(SELECT achats FROM logiciel	WHERE codelogi = 'log3')
	SELECT '16-09-98',REF(d)
	FROM departement d
	WHERE d.codedept = 'D2';
--
SELECT	codelogi,nomlogi FROM logiciel;
SELECT	* FROM departement;
SELECT	nomserv,typeserv FROM serveur;
SELECT	log1.proprietaire.codedept "Dept log1", 
	log1.dateachat "Achat"
	FROM THE(SELECT achats FROM logiciel	
		WHERE codelogi = 'log1') log1;
SELECT	log2.proprietaire.codedept "Dept log2",
	log2.dateachat "Achat"
	FROM THE(SELECT achats FROM logiciel	
		WHERE codelogi = 'log2') log2;
SELECT	log3.proprietaire.codedept "Dept log3",
	 log3.dateachat "Achat"
	FROM THE(SELECT achats FROM logiciel	
		WHERE codelogi = 'log3') log3;