-- Chap8  Contrainte de simultaneite

--Avant
SELECT	p.numpil, p.nom, p.grade	
	FROM pilote p
	WHERE p.sani IS NOT NULL OR p.entraine IS NOT NULL;

-- Appel de la procedure par PL/SQL
DECLARE
	pilote1affecteONU1  pilote_type;
	pilote2affecteENT2  pilote_type;
	pilote3affecteENT2  pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote1affecteONU1
		FROM pilote p
		WHERE p.numpil = 1;
	pilote1affecteONU1.rattache_sani_ent('ONU1','ENT1');
	SELECT	VALUE(p) INTO pilote2affecteENT2 
		FROM pilote p
		WHERE p.numpil = 2;
	pilote2affecteENT2.rattache_sani_ent('ONU2','ENT2');
	SELECT	VALUE(p) INTO pilote3affecteENT2
		FROM pilote p
		WHERE p.numpil = 3;
	pilote3affecteENT2.rattache_sani_ent('ENT2',NULL);
END;
/

--Apres
SELECT	p.numpil, p.nom, p.grade, 
	p.sani.codesan "Sanitaire", p.entraine.codent "Entraine"
	FROM pilote p
	WHERE p.sani IS NOT NULL OR p.entraine IS NOT NULL;


-- Appel de la procedure par PL/SQL
DECLARE
	pilote1affecteENT2  pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote1affecteENT2 
		FROM pilote p
		WHERE p.numpil = 1;
	pilote1affecteENT2.detache_sani_ent();
END;
/
--Apres
SELECT	p.numpil, p.nom, p.grade, 
	p.sani.codesan "Sanitaire", p.entraine.codent "Entraine"
	FROM pilote p
	WHERE p.sani IS NOT NULL OR p.entraine IS NOT NULL;

DROP TRIGGER T_I_VERIF_PILOTE;
drop table pilote;
drop table entrainement;
drop table sanitaire;

drop type pilote_type;
drop type entrainement_type;
drop type sanitaire_type;
