-- Annexe 2
-- Corrige requetes multitables en relationnel

--19.  Numro et capacit des bureaux o on 
--    peut trouver au moins un poste de type 'Win95'.
--schema 1 (sens bureau->poste) :
SELECT	nbureau "LOCAL", capacite
	FROM bureau1 b
	WHERE EXISTS
		((SELECT 'Win95' FROM DUAL)
		INTERSECT
		(SELECT nestedbur.poste_t.typeposte
		    FROM THE(SELECT equipements FROM bureau1 b2 
	                     WHERE b2.nbureau=b.nbureau) nestedbur));

--schema 1 (sens poste->bureau) :
SELECT	DISTINCT p.localisation.nbureau "LOCAL", 
	p.localisation.capacite
	FROM poste_travail1 p
	WHERE p.typeposte = 'Win95';

--schema 2 :
SELECT	DISTINCT c.localisation.nbureau "LOCAL", 
	c.localisation.capacite
	FROM contient2 c
	WHERE c.connexion.typeposte = 'Win95';

--20.  Numeros et capacits des bureaux parcourus par le segment '130.40.32'
--schema 1 :
SELECT	nestedlocaux.local.nbureau "LOCAL",
	nestedlocaux.local.capacite "CAPACITE"
	FROM  THE (SELECT locaux FROM segment1 s
		   WHERE s.ind_IP = '130.40.32') nestedlocaux;
--schema 2 :
SELECT	t.bur.nbureau "LOCAL",
	t.bur.capacite "CAPACITE"
	FROM  traverse2 t
	WHERE t.seg.ind_ip = '130.40.32';

--21.  Capacit globale des bureaux parcourus par le segment '130.40.32'
--schema 1 :
SELECT	SUM(nestedlocaux.local.capacite) "Capacite segment 32"
	FROM  THE (SELECT locaux FROM segment1 s
		   WHERE s.ind_IP = '130.40.32') nestedlocaux;
--schema 2 :
SELECT	SUM(t.bur.capacite) "Capacite segment 32"
	FROM  traverse2 t
	WHERE t.seg.ind_IP = '130.40.32';


--22. Etage des bureaux o on peut trouver deux postes de type 'TX'.
--schema 1 (sens bureau->poste) :
SELECT	etage
	FROM bureau1 b
	WHERE (2= (SELECT COUNT(nestedbur.poste_t.typeposte)
		    FROM THE(SELECT equipements FROM bureau1 b2 
	                     WHERE b2.nbureau=b.nbureau) nestedbur
		    WHERE nestedbur.poste_t.typeposte = 'TX'));

--schema 1 (sens poste->bureau) :
SELECT	p.localisation.etage "ETAGE"
	FROM poste_travail1 p
	WHERE p.typeposte = 'TX'
	GROUP BY p.localisation
	HAVING COUNT(*) = 2;

--schema 2 :
SELECT	c.localisation.etage "ETAGE"
	FROM contient2 c
	WHERE c.connexion.typeposte = 'TX'
	GROUP BY c.localisation
	HAVING COUNT(*) = 2;


--23. Types des postes de travail qu'on peut trouver  la fois 
--   dans les bureaux du 2me tage et du 3me tage.

--schema 1 (sens poste->bureau) :
COLUMN typeposte FORMAT A30 HEADING "Types au 2eme et 3eme etage"
SELECT	p.typeposte 
	FROM poste_travail1 p
	WHERE p.localisation.etage = 2
INTERSECT
SELECT	p.typeposte
	FROM poste_travail1 p
	WHERE p.localisation.etage = 3;
CLEAR COLUMNS

--schema 2 :
COLUMN connexion.typeposte FORMAT A30 HEADING "Types au 2eme et 3eme etage"
SELECT	c.connexion.typeposte 
	FROM contient2 c
	WHERE c.localisation.etage = 2
INTERSECT
SELECT	c.connexion.typeposte
	FROM contient2 c
	WHERE c.localisation.etage = 3;
CLEAR COLUMNS



--24. Installations du logiciel 'log6'
--schema 1 :
SELECT	ntlog6.poste.nserie "Poste", 
	ntlog6.poste.typeposte "Type",
	ntlog6.dateinst "Date"
	FROM THE(SELECT installations FROM logiciel1
		 WHERE codelogi = 'log6') ntlog6
	ORDER BY 3;

--schema 2 :
SELECT	i.poste.nserie "Poste", 
	i.poste.typeposte "Type",
	i.dateinst "Date"
	FROM installe2 i
	WHERE i.logi.codelogi = 'log6'
	ORDER BY 3;

--25. Installations du logiciel 'log6' avec l'@ IP complete
--schema 1 :
SELECT	ntlog6.poste.nserie "Poste",
	ntlog6.poste.connexion.ind_IP||'.'||ntlog6.poste.adrIP "Adresse IP",
	ntlog6.dateinst "Date"
	FROM THE(SELECT installations FROM logiciel1
		 WHERE codelogi = 'log6') ntlog6
	ORDER BY 3;

--schema 2 :
SELECT	i.poste.nserie "Poste", 
	cx.cable.ind_IP||'.'||i.poste.adrIP "Adresse IP",
	i.dateinst "Date"
	FROM installe2 i, connecte2 cx
	WHERE i.logi.codelogi = 'log6'
	AND   cx.machine = i.poste
	ORDER BY 3;

--26. Installations des logiciels du bureau 'b2'

--schema 1 : PL/SQL

--schema 2 :
SELECT	i.poste.nserie "Poste",
	cx.cable.indIP||'.'||i.poste.adrIP "Adresse IP",
	i.logi.nomlogi "Logiciel",
	i.dateinst "Date"
	FROM installe2 i, contient2 c, connecte2 cx
	WHERE c.localisation.nbureau = 'b1'
	AND c.connexion = i.poste
	AND cx.machine = i.poste;


--27. Installations des logiciels tries par date d'installation

--schema 1 : PL/SQL

--schema 2 :
SELECT	c.localisation.nbureau "Local",
	i.poste.nserie "Poste",
	cx.cable.ind_IP||'.'||i.poste.adrIP "Adresse IP",
	i.logi.nomlogi "Logiciel",
	i.dateinst "Date"
	FROM installe2 i, contient2 c, connecte2 cx
	WHERE c.connexion = i.poste
	AND cx.machine = i.poste
	ORDER BY 5;


--28. Numro et types des postes sur lesquels 
--    sont installs le logiciel de nom 'Windows'
--schema 1 :
SELECT	ntWindows.poste.nserie "Poste",
	ntWindows.poste.typeposte "Type"
	FROM THE(SELECT installations FROM logiciel1
		 WHERE nomlogi = 'Windows') ntWindows;
--schema 2 :
SELECT	i.poste.nserie "Poste",
	i.poste.typeposte "Type"
	FROM installe2 i
	WHERE i.logi.nomlogi = 'Windows';

--29. Numro, adresse IP complete des postes sur lesquels 
--    sont installs le logiciel de nom 'SQL*Net'
--schema 1 :
SELECT	ntSQLNET.poste.nserie "Poste",
	ntSQLNET.poste.connexion.ind_IP||'.'||ntSQLNET.poste.adrIP "Adresse IP"
	FROM THE(SELECT installations FROM logiciel1
		 WHERE nomlogi = 'SQL*Net') ntSQLNET;
--schema 2 :
SELECT	i.poste.nserie "Poste",
	cx.cable.ind_IP||'.'||i.poste.adrIP "Adresse IP"
	FROM installe2 i, connecte2 cx	
	WHERE i.logi.nomlogi = 'SQL*Net'
	AND cx.machine = i.poste;
	
--30. Numro, adresse IP et numeros de bureaux des postes sur lesquels 
--    sont installs le logiciel de nom 'Word'
--schema 1 :
SELECT	ntWord.poste.localisation.nbureau "Local",
	ntWord.poste.nserie "Poste",
	ntWord.poste.connexion.ind_IP||'.'||ntWord.poste.adrIP "Adresse IP"
	FROM THE(SELECT installations FROM logiciel1
		 WHERE nomlogi = 'Word') ntWord;

--schema 2 :
SELECT	c.localisation.nbureau "Local",
	i.poste.nserie "Poste",
	cx.cable.ind_IP||'.'||i.poste.adrIP "Adresse IP"
	FROM installe2 i, contient2 c, connecte2 cx
	WHERE i.logi.nomlogi = 'Word'
	AND cx.machine = i.poste
	AND c.connexion = i.poste;



--31. Nom des logiciels ont t installs le 15/5/97
--schema 1 :
COLUMN nomlogi FORMAT A25 HEADING "Installations 15/5/97"
SELECT	nomlogi 
	FROM logiciel1 l
	WHERE EXISTS(
	(SELECT TO_DATE('15/05/97') FROM DUAL)
	INTERSECT 
	(SELECT ntlog.dateinst
	FROM THE(SELECT installations FROM logiciel1
		 WHERE codelogi = l.codelogi) ntlog));
CLEAR COLUMNS

--schema 2 :
COLUMN logi.nomlogi FORMAT A25 HEADING "Installations 15/5/97"
SELECT	i.logi.nomlogi 
	FROM installe2 i
	WHERE i.dateinst = TO_DATE('15/05/97');
CLEAR COLUMNS


--32. Nom des logiciels qui ont t installs le jour de leur achat
--schema 1 :
COLUMN nomlogi FORMAT A25 HEADING "Installations rapides"
SELECT	DISTINCT nomlogi 
	FROM logiciel1 l
	WHERE EXISTS
	((SELECT dateachat FROM logiciel1 l2
		WHERE l2.codelogi = l.codelogi)
	INTERSECT 
	(SELECT ntlog.dateinst
	FROM THE(SELECT installations FROM logiciel1
		 WHERE codelogi = l.codelogi) ntlog));
CLEAR COLUMNS

--schema 2 :
COLUMN logi.nomlogi FORMAT A25 HEADING "Installations rapides"
SELECT	DISTINCT i.logi.nomlogi 
	FROM installe2 i
	WHERE i.dateinst = i.logi.dateachat;
CLEAR COLUMNS


--33. Nom des logiciels qui ont t installs 2 jours apres l'achat
--schema 1 :
COLUMN nomlogi FORMAT A20 HEADING "Installations + 2j"
SELECT	DISTINCT nomlogi 
	FROM logiciel1 l
	WHERE EXISTS
	((SELECT dateachat+2 FROM logiciel1 l2
		WHERE l2.codelogi = l.codelogi)
	INTERSECT 
	(SELECT ntlog.dateinst
	FROM THE(SELECT installations FROM logiciel1
		 WHERE codelogi = l.codelogi) ntlog));
CLEAR COLUMNS

--schema 2 :
COLUMN logi.nomlogi FORMAT A20 HEADING "Installations + 2j"
SELECT	DISTINCT i.logi.nomlogi 
	FROM installe2 i
	WHERE i.dateinst = i.logi.dateachat+2;
CLEAR COLUMNS


--34. Postes et dates d'installations du logiciel 'Windows' 
--    version '95'
--schema 1 :
SELECT	ntlog.dateinst "Date",
	ntlog.poste.nserie  "Poste"
	FROM THE(SELECT installations FROM logiciel1
		 WHERE nomlogi = 'Windows' 
		 AND version = '95') ntlog;
--schema 2 :
SELECT	i.dateinst "Date",
	i.poste.nserie  "Poste"
	FROM installe2 i
	WHERE i.logi.nomlogi = 'Windows' 
	AND i.logi.version = '95';


--35. Dates des installations des logiciels achets le 13/5/95 
--    pour UnixHP et qui sont installs sur les postes des 
--    bureaux dont la capacit excde 4 places
--schema 1 : PL/SQL

--schema 2 :
SELECT	i.logi.nomlogi "Logiciel",
	i.dateinst "Date"
	FROM installe2 i, contient2 c
	WHERE i.logi.dateachat = TO_DATE('13/05/95')
	AND i.logi.typeOS = 'UnixHP'
	AND c.localisation.capacite > 4
	AND c.connexion = i.poste;