-- Corrige 8.1
-- Installations d'un logiciel sur les postes d'un segment
--SCHEMA 2

--Modification du type : declaration de la methode
ALTER TYPE segment2_type REPLACE AS OBJECT
 (ind_IP varchar2(11), longueur number,
  MEMBER PROCEDURE installe_logiciel_segment(clog IN varchar2,
	nomlog IN varchar2, verlog IN varchar2, datlog IN date,
	typlog IN varchar2),
  PRAGMA RESTRICT_REFERENCES(installe_logiciel_segment,RNPS,WNPS))
/

--Table optionnelle et temporaire qui permet de tracer les operations
DROP TABLE compte_rendu;
CREATE TABLE compte_rendu (message VARCHAR(80));

--Corps de la methode
CREATE OR REPLACE TYPE BODY segment2_type AS
MEMBER PROCEDURE installe_logiciel_segment(clog IN varchar2,
	nomlog IN varchar2, verlog IN varchar2, datlog IN date,
	typlog IN varchar2)
IS
	CURSOR c1 IS SELECT c.machine.nserie
		FROM  connecte2 c
		WHERE c.machine.typeposte = typlog
		AND   c.cable.ind_IP = SELF.ind_IP;
	c1_rec c1%ROWTYPE;
BEGIN
	--Enregistrement du nouveau logiciel
	INSERT INTO logiciel2 VALUES (clog,nomlog,verlog,datlog,typlog);
	INSERT INTO compte_rendu VALUES
	('Enregistrement de ' || clog || ' dans logiciel2');

	-- Recuperation des postes du segment concerns par l'install	
	FOR c1_rec IN c1 LOOP
	   INSERT INTO installe2
		SELECT REF(l),REF(p),SYSDATE
		FROM poste_travail2 p, logiciel2 l
		WHERE p.nserie = c1_rec.nserie
		AND l.codelogi = clog;

	   INSERT INTO compte_rendu VALUES
	   ('Installation sur '||c1_rec.nserie);
	END LOOP;
	
	INSERT INTO compte_rendu VALUES('Transaction termine ....');
	COMMIT;
END installe_logiciel_segment;
END;
/

--Appel de la methode

--Avant appel
SELECT * FROM compte_rendu;
SELECT * FROM logiciel2;
SELECT i.logi.codelogi, i.poste.nserie, i.dateinst
	FROM installe2 i;

DECLARE
	segment_a_installer segment2_type;
BEGIN
	SELECT	VALUE(s) INTO segment_a_installer
		FROM segment2 s
		WHERE s.ind_IP = '130.40.30';
	segment_a_installer.installe_logiciel_segment('log9',
		'Powerpoint','97',TO_DATE('14-08-98'),'Win95');
END;
/


--Apres appel
SELECT * FROM compte_rendu;
SELECT * FROM compte_rendu;
SELECT * FROM logiciel2;
SELECT i.logi.codelogi, i.poste.nserie, i.dateinst
	FROM installe2 i;


DROP TABLE compte_rendu;

