-- Corrige Chap8 Vues OR

-- Creation des vues

CREATE OR REPLACE TYPE poste_travail_type AS OBJECT
 (nserie VARCHAR(7), adrIP VARCHAR(2), typeposte VARCHAR(6))
/
CREATE OR REPLACE TYPE logiciel_type AS OBJECT
 (clogi VARCHAR(5), nomlogi VARCHAR(20),
 version VARCHAR(7), typeOS VARCHAR(6))
/

--Vues
CREATE VIEW v_poste_travail OF poste_travail_type
	WITH OBJECT OID (nserie)
	AS SELECT * FROM poste_travail;
CREATE	VIEW v_logiciel OF logiciel_type
	WITH OBJECT OID (clogi)
	AS SELECT * FROM logiciel;

SELECT * FROM v_poste_travail;
SELECT * FROM v_logiciel;

CREATE	OR REPLACE VIEW v_installe
AS	SELECT 
	MAKE_REF(v_logiciel, clogi) logi,
	MAKE_REF(v_poste_travail, nserie) poste,
	i.dateinst
	FROM v_logiciel vl, installe i, v_poste_travail vp
	WHERE i.codelogi = vl.clogi
	AND i.nposte = vp.nserie;
DESC v_installe

CREATE OR REPLACE TYPE poste_date_type AS OBJECT
 (poste_ref REF poste_travail_type, dinst DATE)
/
CREATE OR REPLACE TYPE postes_date_type AS TABLE OF poste_date_type
/

--Vue qui simule une nested table avec un REF dans logiciel
CREATE OR REPLACE VIEW v_logiciel_2
AS 
SELECT	l.codelogi,l.nomlogi, l.version,l.typeOS,
	CAST (MULTISET (SELECT vi.poste,vi.dateinst
			FROM v_installe vi
			WHERE vi.logi.clogi = l.codelogi) 
	AS postes_date_type) insts
FROM logiciel l;
DESC v_logiciel_2
 
SELECT	v.logi.clogi,v.poste.nserie,v.dateinst
	FROM  v_installe v;

--Interrogation de la vue
SELECT	nested_insts_log1.poste_ref.nserie "Poste",
	nested_insts_log1.poste_ref.adrIP "IP",
	nested_insts_log1.poste_ref.typeposte "Type",
	nested_insts_log1.dinst "Date"
	FROM THE(SELECT insts
		FROM v_logiciel_2
		WHERE codelogi='log1') nested_insts_log1;

--
DROP VIEW v_poste_travail;
DROP VIEW v_logiciel;
DROP VIEW v_installe;

DROP TYPE postes_date_type FORCE;
DROP TYPE poste_date_type;
DROP TYPE poste_travail_type;
DROP TYPE logiciel_type;

DROP TABLE installe;
DROP TABLE poste_travail;
DROP TABLE logiciel;




