-- Chap8 Exclusion (appels aux methodes)


--Avant
SELECT	m.pilsani.numpil, m.misani.codesan	
	FROM missionsani m;

SELECT	m.pilent.numpil, m.misent.codent
	FROM missionent m;

-- Appel des methodes par PL/SQL
DECLARE
	pilote1affecteONU1  pilote_type;
	pilote2affecteENT2  pilote_type;
	pilote3affecteENT2  pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote1affecteONU1
		FROM pilote p
		WHERE p.numpil = 1;
	pilote1affecteONU1.rattache_sanitaire('ONU1');
	SELECT	VALUE(p) INTO pilote2affecteENT2 
		FROM pilote p
		WHERE p.numpil = 2;
	pilote2affecteENT2.rattache_entrainement('ENT2');
	SELECT	VALUE(p) INTO pilote3affecteENT2
		FROM pilote p
		WHERE p.numpil = 3;
	pilote3affecteENT2.rattache_entrainement('ENT2');
END;
/

--Apres
SELECT	m.pilsani.numpil, m.misani.codesan	
	FROM missionsani m;
SELECT	m.pilent.numpil, m.misent.codent
	FROM missionent m;


-- Essais de changements d'affectations
DECLARE
	pilote1affecteENT2  pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote1affecteENT2 
		FROM pilote p
		WHERE p.numpil = 1;
	pilote1affecteENT2.rattache_entrainement('ENT2');
END;
/

DECLARE
	pilote2affecteONU2  pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote2affecteONU2 
		FROM pilote p
		WHERE p.numpil = 2;
	pilote2affecteONU2.rattache_sanitaire('ONU2');
END;
/

--Apres rien n'a bouge
SELECT	m.pilsani.numpil, m.misani.codesan	
	FROM missionsani m;
SELECT	m.pilent.numpil, m.misent.codent
	FROM missionent m;

--Detachement des 2 pilotes
DECLARE
	pilote_a_dettacher  pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote_a_dettacher 
		FROM pilote p
		WHERE p.numpil = 1;
	pilote_a_dettacher.detache_sanitaire('ONU1');
	SELECT	VALUE(p) INTO pilote_a_dettacher  
		FROM pilote p
		WHERE p.numpil = 2;
	pilote_a_dettacher.detache_entrainement('ENT2');
END;
/
--Apres le detachement
SELECT	m.pilsani.numpil, m.misani.codesan	
	FROM missionsani m;
SELECT	m.pilent.numpil, m.misent.codent
	FROM missionent m;

-- Changements d'affectations
DECLARE
	pilote1affecteENT2  pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote1affecteENT2 
		FROM pilote p
		WHERE p.numpil = 1;
	pilote1affecteENT2.rattache_entrainement('ENT2');
END;
/

DECLARE
	pilote2affecteONU2  pilote_type;
BEGIN
	SELECT	VALUE(p) INTO pilote2affecteONU2 
		FROM pilote p
		WHERE p.numpil = 2;
	pilote2affecteONU2.rattache_sanitaire('ONU2');
END;
/
--Apres 2 pilotes ont ete mutes
SELECT	m.pilsani.numpil, m.misani.codesan	
	FROM missionsani m;
SELECT	m.pilent.numpil, m.misent.codent
	FROM missionent m;
