-- Chap8 Exclusion (creation des tables Oracle8)

CREATE TYPE sanitaire_type AS OBJECT
 (codesan varchar(10), organisme varchar(20))
/
CREATE TYPE entrainement_type AS OBJECT
 (codent varchar(10), datent DATE, region varchar(20))
/
CREATE TYPE pilote_type AS OBJECT
 (numpil NUMBER, nom varchar(10), grade varchar(10),
  MEMBER PROCEDURE rattache_sanitaire(missionsanitaire IN varchar),
  PRAGMA RESTRICT_REFERENCES(rattache_sanitaire,RNPS,WNPS),
  MEMBER PROCEDURE detache_sanitaire(missionsanitaire IN varchar),
  PRAGMA RESTRICT_REFERENCES(detache_sanitaire,RNPS,WNPS),
  MEMBER PROCEDURE rattache_entrainement(missionentraine IN varchar),
  PRAGMA RESTRICT_REFERENCES(rattache_entrainement,RNPS,WNPS),
  MEMBER PROCEDURE detache_entrainement(missionentraine IN varchar),
  PRAGMA RESTRICT_REFERENCES(detache_entrainement,RNPS,WNPS))
/
CREATE TYPE missionsani_type AS OBJECT
 (pilsani REF pilote_type, misani REF sanitaire_type)
/
CREATE TYPE missionent_type AS OBJECT
 (pilent REF pilote_type, misent REF entrainement_type)
/
CREATE TABLE sanitaire OF sanitaire_type 
 (constraint pk_sanitaire primary key(codesan));
CREATE TABLE entrainement OF entrainement_type
 (constraint pk_entraine primary key(codent));
CREATE TABLE pilote  OF pilote_type
 (constraint pk_pilote primary key(numpil));
CREATE TABLE missionsani OF missionsani_type;
CREATE TABLE missionent  OF missionent_type;


--
delete from missionsani;
delete from missionent;
delete from pilote;
delete from entrainement;
delete from sanitaire;

insert into sanitaire values ('ONU1','ONU en Bosnie');
insert into sanitaire values ('ONU2','ONU au Congo');
insert into entrainement values ('ENT1','20-12-98','Pays basque');
insert into entrainement values ('ENT2','22-12-98','Toulouse Sud');
insert into entrainement values ('ENT3','22-12-98','Salon de Provence');
insert into pilote values(1,'B. Danny','Colonel');
insert into pilote values(2,'Tanguy','Colonel');
insert into pilote values(3,'Laverdure','Capitaine');

--
SELECT * FROM sanitaire;
SELECT * FROM entrainement;
SELECT	* FROM pilote;


--
DROP TABLE  missionsani;
DROP TABLE missionent;
drop table pilote;
drop table entrainement;
drop table sanitaire;

DROP TYPE missionsani_type;
DROP TYPE missionent_type;
drop type pilote_type;
drop type entrainement_type;
drop type sanitaire_type;