-- Chap8 Exclusion (methodes)

CREATE OR REPLACE TYPE BODY pilote_type AS
 MEMBER PROCEDURE rattache_sanitaire(missionsanitaire IN varchar) IS
	refmissionent REF missionent_type;
   BEGIN
	DELETE FROM  missionsani m WHERE m.pilsani.numpil = SELF.numpil;
	SELECT	REF(m) INTO refmissionent
		FROM missionent m
		WHERE m.pilent.numpil  = SELF.numpil;	
	IF (refmissionent IS NOT NULL) THEN
		 RAISE_APPLICATION_ERROR(-20101,'Le pilote ' || TO_CHAR(SELF.numpil) ||
		 ' est deja affecte a une mission d''entrainement');		
	END IF;
  EXCEPTION
	WHEN NO_DATA_FOUND THEN 
		INSERT INTO missionsani 
		SELECT	REF(p),REF(s)
			FROM pilote p, sanitaire s
			WHERE p.numpil = SELF.numpil
			AND   s.codesan = missionsanitaire;
  END rattache_sanitaire;
 MEMBER PROCEDURE rattache_entrainement(missionentraine IN varchar) IS
	refmissionsani REF missionsani_type;
  BEGIN
	DELETE FROM  missionent m  WHERE m.pilent.numpil  = SELF.numpil;
	SELECT	REF(m) INTO refmissionsani
		FROM missionsani m
		WHERE m.pilsani.numpil  = SELF.numpil;
	IF (refmissionsani IS NOT NULL) THEN
		 RAISE_APPLICATION_ERROR(-20101,'Le pilote ' || TO_CHAR(SELF.numpil) ||
		 ' est deja affecte a une mission sanitaire');
	END IF;
  EXCEPTION
	WHEN NO_DATA_FOUND THEN 
		INSERT INTO missionent 
		SELECT	REF(p),REF(e)
			FROM pilote p, entrainement e
			WHERE p.numpil = SELF.numpil
			AND   e.codent = missionentraine;	
  END rattache_entrainement;
 MEMBER PROCEDURE detache_entrainement(missionentraine IN varchar) IS
  BEGIN
	DELETE	FROM  missionent m 
		WHERE m.pilent.numpil  = SELF.numpil;
  END detache_entrainement;
 MEMBER PROCEDURE detache_sanitaire(missionsanitaire IN varchar) IS
  BEGIN
   	DELETE	FROM  missionsani m
		WHERE m.pilsani.numpil = SELF.numpil;
 END detache_sanitaire;
END;
/