-- Chap8  Contrainte d'inclusion (methodes)

--Methode affectation d'un stage
CREATE OR REPLACE TYPE BODY etudiant_type AS
 MEMBER PROCEDURE affecte_stage(stage_a_affecter IN NUMBER) IS
  trace          NUMBER;	
  refvoeux       REF voeux_type;
  refaffectation REF etudiant_type;
  refetudiant    REF etudiant_type;
  refstage       REF stage_type;
  numstageancien stage.numsta%TYPE;
   BEGIN
	trace := 1;
	--Le stage a t-il ete demande?
	SELECT	REF(v) INTO refvoeux
		FROM voeux v
		WHERE v.etud.ninsee  = SELF.ninsee
		AND   v.stag.numsta  = stage_a_affecter;

	--Le stage existe t-il?
	trace := 2;
	SELECT	REF(s) INTO refstage
		FROM  stage s
		WHERE s.numsta  = stage_a_affecter;
	
	--Le stage est-il deja affecte?
	refaffectation := NULL;
	SELECT	s.affectation INTO refaffectation
		FROM  stage s
		WHERE s.numsta  = stage_a_affecter;
	IF (refaffectation IS NOT NULL) THEN
	RAISE_APPLICATION_ERROR(-20101,'Le stage ' || TO_CHAR(stage_a_affecter)
	|| ' est deja affecte, desole...');
	END IF;
	-- Recuperation de l'OID de l'etudiant en question
	-- Si pas trouve grosse erreur
	trace := 3;
	SELECT	REF(e) INTO refetudiant
		FROM etudiant e
		WHERE e.ninsee  = SELF.ninsee;

	-- Recuperation de l'OID de l'ancien stage
	-- Si pas trouve pas d'erreur
	trace := 4;
	SELECT	numsta INTO numstageancien
		FROM stage s
		WHERE s.affectation.ninsee = SELF.ninsee;

	trace := 5;
	-- Recuperation de l'OID de l'etudiant en question
	-- Si pas trouve grosse erreur
	SELECT	REF(e) INTO refetudiant
		FROM etudiant e
		WHERE e.ninsee  = SELF.ninsee;

	-- Affectation du stage
	UPDATE stage s
		SET s.affectation = refetudiant
		WHERE s.numsta  = stage_a_affecter;

	--On desaffecte l'ancien stage
	UPDATE stage s
		SET s.affectation = NULL
		WHERE s.numsta  = numstageancien;
  EXCEPTION
	WHEN NO_DATA_FOUND THEN 
	IF (trace = 1) THEN
	 RAISE_APPLICATION_ERROR(-20101,'L''etudiant ' 
	|| SELF.nom || ' n''a pas demande prealablement le stage ' 
	 || TO_CHAR(stage_a_affecter));		
	END IF;
	IF (trace = 2) THEN
	RAISE_APPLICATION_ERROR(-20101,'Le stage ' || TO_CHAR(stage_a_affecter)
	|| ' n''est pas dans la base');
	END IF;
	IF (trace = 4) THEN
		UPDATE stage s
		SET s.affectation = refetudiant
		WHERE s.numsta  = stage_a_affecter;
	END IF;
	IF (trace = 3 OR trace =5) THEN
		RAISE_APPLICATION_ERROR(-20101,'Base incoherente...');
	END IF;
  END affecte_stage;
 END;
/

CREATE OR REPLACE TYPE BODY stage_type AS
MEMBER PROCEDURE desaffecte_stage IS
   BEGIN
	UPDATE	stage s
		SET s.affectation = NULL
		WHERE s.numsta = SELF.numsta;
   END desaffecte_stage;
 END;
/

--Appels de la methode
--Avant
SELECT	s.numsta "Affectation",
	s.theme "Theme",
	s.affectation.nom "ETUDIANT"
	FROM stage s;

DECLARE
	etudiant_affecte etudiant_type;
BEGIN
	SELECT	VALUE(e) INTO etudiant_affecte
		FROM etudiant e
		WHERE e.ninsee = '1650275062009';
	etudiant_affecte.affecte_stage(1);
	SELECT	VALUE(e) INTO etudiant_affecte
		FROM etudiant e
		WHERE e.ninsee = '1450258964125';
	etudiant_affecte.affecte_stage(2);
END;
/

--Apres
SELECT	s.numsta "Affectation",
	s.theme "Theme",
	s.affectation.nom "ETUDIANT"
	FROM stage s;

--Essais de cas d'erreurs
DECLARE
	etudiant_affecte etudiant_type;
BEGIN
	SELECT	VALUE(e) INTO etudiant_affecte
		FROM etudiant e
		WHERE e.ninsee = '1650275062009';
	etudiant_affecte.affecte_stage(3);
END;
/
DECLARE
	etudiant_affecte etudiant_type;
BEGIN
	SELECT	VALUE(e) INTO etudiant_affecte
		FROM etudiant e
		WHERE e.ninsee = '1650275062009';
	etudiant_affecte.affecte_stage(2);
END;
/
--Apres
SELECT	s.numsta "Affectation",
	s.theme "Theme",
	s.affectation.nom "ETUDIANT"
	FROM stage s;


--Changements de stage
DECLARE
	etudiant_affecte etudiant_type;
BEGIN
	SELECT	VALUE(e) INTO etudiant_affecte
		FROM etudiant e
		WHERE e.ninsee = '1450258964125';
	etudiant_affecte.affecte_stage(3);
	SELECT	VALUE(e) INTO etudiant_affecte
		FROM etudiant e
		WHERE e.ninsee = '1650275062009';
	etudiant_affecte.affecte_stage(2);
END;
/
--Apres
SELECT	s.numsta "Affectation",
	s.theme "Theme",
	s.affectation.nom "ETUDIANT"
	FROM stage s;

--Detachement de stage
DECLARE
	stage_desaffecte stage_type;
BEGIN
	SELECT	VALUE(s) INTO stage_desaffecte
		FROM stage s
		WHERE s.numsta = 3;
	stage_desaffecte.desaffecte_stage();
END;
/

--Apres
SELECT	s.numsta "Affectation",
	s.theme "Theme",
	s.affectation.nom "ETUDIANT"
	FROM stage s;

--Fin
DROP PROCEDURE saisie_voeux;
DROP TABLE voeux;
DROP TABLE stage;
DROP TABLE etudiant;
DROP TYPE voeux_type;
DROP TYPE stage_type;
DROP TYPE etudiant_type;
