-- Chap8  Contrainte de Partition (trigger)


CREATE OR REPLACE TRIGGER T_I_VERIF_PILOTE
	AFTER INSERT ON pilote
	FOR EACH ROW
BEGIN
	IF (:new.sani IS NOT NULL AND :new.entraine IS NOT NULL) THEN
		 RAISE_APPLICATION_ERROR(-20101,'Le pilote ' || TO_CHAR(:new.numpil) ||
		 ' ne peut pas etre affecte a deux missions');
	END IF;
	IF (:new.sani IS NULL AND :new.entraine IS NULL) THEN
		 RAISE_APPLICATION_ERROR(-20101,'Le pilote ' || TO_CHAR(:new.numpil) ||
		 ' ne peut pas etre affecte a aucune mission');
	END IF;
END;
/

--insert ok
INSERT INTO pilote
	SELECT 4,'Soutou','Lieutenant',	NULL,REF(e)del
	FROM entrainement e 
	WHERE e.codent = 'ENT1';
--insert PB
INSERT INTO pilote
	SELECT 5,'Sigaudes','Lieutenant',REF(s),REF(e)
	FROM entrainement e, sanitaire s
	WHERE e.codent = 'ENT1'
	AND   s.codesan = 'ONU1';
--insert PB
INSERT INTO pilote VALUES (6,'Filoux','Lieutenant',NULL,NULL);
--Apres
SELECT	p.numpil, p.nom, p.grade, 
	p.sani.codesan "Sanitaire", p.entraine.codent "Entraine"
	FROM pilote p
	WHERE p.sani IS NOT NULL OR p.entraine IS NOT NULL;


DROP TRIGGER T_I_VERIF_PILOTE;