-- Chap8  Contrainte de Totalite (Procedure)

--Procedure creation des pilotes
CREATE OR REPLACE PROCEDURE creation_pilote
	(numeropilote  IN pilote.numpil%TYPE,
	 nompilote     IN pilote.nom%TYPE,
	 gradepilote   IN pilote.grade%TYPE,
	 codesanitaire IN sanitaire.codesan%TYPE,
	 codeentraine  IN entrainement.codent%TYPE) AS
 tempsan sanitaire.codesan%TYPE;
 tempent entrainement.codent%TYPE;
BEGIN
	IF (codesanitaire IS NULL AND codeentraine IS NULL) THEN
		 RAISE_APPLICATION_ERROR(-20101,'Le pilote ' || TO_CHAR(numeropilote) ||
		 ' ne peut pas etre affecte a aucune mission');
	ELSIF (codesanitaire IS NOT NULL AND codeentraine IS NULL) THEN
		SELECT codesan INTO tempsan FROM sanitaire WHERE codesan = codesanitaire;
		INSERT INTO pilote 
			SELECT	numeropilote,nompilote,gradepilote,REF(ms),NULL
			FROM  sanitaire ms
			WHERE ms.codesan = codesanitaire;
	ELSIF (codesanitaire IS NULL AND codeentraine IS NOT NULL) THEN
		SELECT codent INTO tempent FROM entrainement WHERE codent = codeentraine;
		INSERT INTO pilote
			SELECT	numeropilote,nompilote,gradepilote,NULL,REF(me)
			FROM  entrainement me
			WHERE me.codent = codeentraine;
	ELSE
		INSERT INTO pilote
			SELECT	numeropilote,nompilote,gradepilote,REF(ms),REF(me)
			FROM  sanitaire ms, entrainement me
			WHERE ms.codesan = codesanitaire
			AND   me.codent  = codeentraine;
	END IF;
EXCEPTION
	WHEN NO_DATA_FOUND THEN 
		RAISE_APPLICATION_ERROR(-20101,'Le pilote ' || TO_CHAR(numeropilote) ||
		 ' ne peut pas etre affecte a une mission inexistante');
END;
/